/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.lists;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.adhoclists.AdhocListsException;
import com.comalatech.confluence.adhoclists.lists.ChecklistResolver;
import com.comalatech.confluence.adhoclists.lists.model.ChecklistViewContext;
import com.comalatech.confluence.adhoclists.model.BoardLabel;
import com.comalatech.confluence.adhoclists.model.ResolvedFilter;
import com.comalatech.confluence.adhoclists.model.SortType;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultChecklistResolver
implements ChecklistResolver {
    private static final Logger log = LoggerFactory.getLogger(DefaultChecklistResolver.class);
    private final CQLSearchService cqlSearchService;
    private final PageManager pageManager;
    public static final String CQL_ORDER_ASCENDING = "asc";
    public static final String CQL_ORDER_DESCENDING = "desc";

    public DefaultChecklistResolver(@ComponentImport CQLSearchService cqlSearchService, @ComponentImport PageManager pageManager) {
        this.cqlSearchService = cqlSearchService;
        this.pageManager = pageManager;
    }

    @Override
    public List<SpaceContentEntityObject> getRows(ChecklistViewContext viewContext, ResolvedFilter filter) throws AdhocListsException {
        ArrayList<SpaceContentEntityObject> pages = new ArrayList<SpaceContentEntityObject>();
        String cqlQuery = this.getCqlFromFilter(viewContext, filter);
        int start = viewContext.getStart();
        int limit = viewContext.getCount();
        int depth = filter.getDepth();
        try {
            if (depth == 0 || filter.getParentPage() == null) {
                PageResponse pageResponse = this.cqlSearchService.searchContent(cqlQuery, (PageRequest)new SimplePageRequest(start, limit), new Expansion[0]);
                for (Content content : pageResponse.getResults()) {
                    pages.add((SpaceContentEntityObject)this.pageManager.getAbstractPage(content.getId().asLong()));
                }
                viewContext.setStart(start + pages.size());
                viewContext.setHasMore(pageResponse.hasMore());
            } else if (depth > 0) {
                boolean hasMore = true;
                while (pages.size() < limit && hasMore) {
                    PageResponse pageResponse = this.cqlSearchService.searchContent(cqlQuery, (PageRequest)new SimplePageRequest(start, limit), new Expansion[]{new Expansion("ancestors")});
                    int effectiveDepth = filter.getParentPage() != null && filter.getParentPage().getAncestors() != null ? depth + filter.getParentPage().getAncestors().size() : depth;
                    for (Content content : pageResponse.getResults()) {
                        if (effectiveDepth < content.getAncestors().size()) continue;
                        pages.add((SpaceContentEntityObject)this.pageManager.getAbstractPage(content.getId().asLong()));
                    }
                    hasMore = pageResponse.hasMore();
                    start += limit;
                }
                viewContext.setStart(start);
                viewContext.setHasMore(hasMore);
            }
        }
        catch (Exception e) {
            log.error("There was an error executing CQL: " + cqlQuery + " with filter: " + filter + ", start = " + start + " and limit = " + limit, (Throwable)e);
        }
        return pages;
    }

    protected String getCqlFromFilter(ChecklistViewContext viewContext, ResolvedFilter filter) {
        StringBuilder cqlQuery = new StringBuilder("type = page");
        if (!filter.isAllSpaces()) {
            String spaceKey;
            if (filter.getParentPage() != null) {
                cqlQuery.append(" AND ancestor = ").append(filter.getParentPage().getIdAsString());
            }
            String string = spaceKey = StringUtils.isNotBlank((CharSequence)filter.getSpaceKey()) ? filter.getSpaceKey() : viewContext.getSpaceKey();
            if (StringUtils.isNotBlank((CharSequence)spaceKey) && filter.getParentPage() == null) {
                cqlQuery.append(" AND space.key = \"").append(spaceKey).append("\"");
            }
        }
        if (filter.getLabelsList() != null && !filter.getLabelsList().isEmpty()) {
            for (BoardLabel label : filter.getLabelsList()) {
                String isNegated = label.isNegated() ? "!" : "";
                cqlQuery.append(" AND label " + isNegated + "= \"").append(label.getName()).append("\"");
            }
        }
        return cqlQuery.append(this.getCqlSortingFromContext(viewContext)).toString();
    }

    protected String getCqlSortingFromContext(ChecklistViewContext viewContext) {
        StringBuilder cqlSorting = new StringBuilder(" ORDER BY");
        SortType sortType = viewContext.getSortType();
        if (sortType != null) {
            if (sortType.getSortBy() == SortType.SortBy.CREATED) {
                cqlSorting.append(" created");
            } else if (sortType.getSortBy() == SortType.SortBy.TITLE) {
                cqlSorting.append(" title");
            } else {
                cqlSorting.append(" lastmodified");
            }
            cqlSorting.append(this.getCqlOrder(sortType.getOrder()));
        } else {
            cqlSorting.append(" lastmodified desc");
        }
        return cqlSorting.toString();
    }

    protected String getCqlOrder(SearchSort.Order order) {
        if (order != null && order.equals((Object)SearchSort.Order.ASCENDING)) {
            return " asc";
        }
        return " desc";
    }
}

