/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.lists;

import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.persistence.dao.LabelSearchResult;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.adhoclists.AbstractTableCreator;
import com.comalatech.confluence.adhoclists.lists.ChecklistCreator;
import com.comalatech.confluence.adhoclists.lists.model.Checklist;
import com.comalatech.confluence.adhoclists.lists.model.PageValueType;
import com.comalatech.confluence.adhoclists.lists.types.LabelColumn;
import com.comalatech.confluence.adhoclists.lists.types.PageColumn;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class DefaultChecklistCreator
extends AbstractTableCreator
implements ChecklistCreator {
    private static final int MAX_POPULAR_LABELS = 10;
    private final LabelManager labelManager;
    private final ComalaI18nBean comalaI18nBean;

    public DefaultChecklistCreator(@ComponentImport LabelManager labelManager, @ComponentImport PermissionManager permissionManager, ComalaI18nBean comalaI18nBean) {
        super(permissionManager);
        this.labelManager = labelManager;
        this.comalaI18nBean = comalaI18nBean;
    }

    @Override
    public Checklist createPopularLabelsChecklist(String spaceKey) {
        List popularLabels = this.labelManager.getMostPopularLabelsInSpace(spaceKey, 10);
        Checklist checklist = new Checklist(this.comalaI18nBean.getText("adhoclists.checklists.space.default.labels"));
        checklist.addColumn(new PageColumn(PageValueType.Type.VIEWLINK));
        checklist.addColumn(new PageColumn(PageValueType.Type.CREATOR));
        checklist.addColumn(new PageColumn(PageValueType.Type.CREATIONDATE));
        checklist.setLeftJustified(true);
        for (LabelSearchResult label : popularLabels) {
            checklist.addColumn(new LabelColumn(label.getLabel()));
        }
        return checklist;
    }
}

