/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.condition;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.adhoclists.condition.RestCondition;
import com.comalatech.confluence.adhoclists.license.AdhocLicenseManager;
import com.comalatech.confluence.adhoclists.license.PluginLicenseAware;

public abstract class ConditionalMacro
extends BaseMacro
implements PluginLicenseAware {
    private final RestCondition restCondition;
    protected SpaceManager spaceManager;
    private final AdhocLicenseManager licenseManager;

    protected ConditionalMacro(RestCondition restCondition, SpaceManager spaceManager, AdhocLicenseManager licenseManager) {
        this.restCondition = restCondition;
        this.spaceManager = spaceManager;
        this.licenseManager = licenseManager;
    }

    public void checkDisplayPermission(ConditionalMacro macro, String spaceKey, MacroCondition condition) throws MacroException {
        Space space = this.spaceManager.getSpace(spaceKey);
        boolean shouldDisplay = false;
        if (condition.name().equals(MacroCondition.SHOWBOARD.name())) {
            shouldDisplay = this.restCondition.isBoardsVisible((ConfluenceEntityObject)space);
        } else if (condition.name().equals(MacroCondition.SHOWLIST.name())) {
            shouldDisplay = this.restCondition.isListsVisible((ConfluenceEntityObject)space);
        }
        if (!shouldDisplay) {
            throw new MacroException(condition.getMessage() + spaceKey);
        }
    }

    @Override
    public AdhocLicenseManager getLicenseManager() {
        return this.licenseManager;
    }

    public static enum MacroCondition {
        SHOWBOARD("Adhoc Boards are not enabled in this space : "),
        SHOWLIST("Adhoc Lists are not enabled in this space : ");

        private final String message;

        private MacroCondition(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

