/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.cards.model;

import com.comalatech.confluence.adhoclists.cards.model.Card;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;

@XmlRootElement(name="card")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ResolvedCard
extends Card {
    @XmlElement(nillable=true)
    String url;
    String title;
    String content;

    public ResolvedCard() {
    }

    public ResolvedCard(ResolvedCard card) {
        super(card);
        this.url = card.url;
        this.title = card.title;
        this.content = card.content;
    }

    public ResolvedCard(String id, String title, String url) {
        this.setId(id);
        this.title = title;
        this.url = url;
    }

    public ResolvedCard(String body) {
        if (!StringUtils.isNotBlank((CharSequence)body)) {
            throw new IllegalArgumentException("body cannot be null");
        }
        this.setBody(body.trim());
        String[] lines = this.getBody().split("\n");
        this.title = lines[0];
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < lines.length; ++i) {
            if (i > 1) {
                sb.append("\n");
            }
            sb.append(lines[i]);
        }
        this.content = sb.toString();
    }

    public Card toCard() {
        this.validate();
        if (this.getId() != null) {
            return new Card(this.getId(), null);
        }
        return new Card(null, this.getBody());
    }

    public String getUrl() {
        return this.url;
    }

    public String getTitle() {
        return this.title;
    }

    protected void setTitle(String title) {
        this.title = title;
    }

    protected void setUrl(String url) {
        this.url = url;
    }

    public String getContent() {
        return this.content;
    }

    @Override
    public String toString() {
        return "ResolvedCard{id='" + this.getId() + "', url='" + this.url + "', title='" + this.title + "', content='" + this.content + "'}";
    }
}

