/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.cards;

import com.atlassian.confluence.core.ContentEntityObject;
import com.comalatech.confluence.adhoclists.cards.CardAccessor;
import com.comalatech.confluence.adhoclists.cards.CardsUtils;
import com.comalatech.confluence.adhoclists.cards.model.Card;
import com.comalatech.confluence.adhoclists.content.ComalaPropertiesSetManager;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultCardAccessor
implements CardAccessor {
    private static final Logger log = LoggerFactory.getLogger(DefaultCardAccessor.class);
    private final ComalaPropertiesSetManager contentPropertyManager;
    private static final String CARDS_PREFIX = "com.comalatech.adhoccanvas.boards.cards.";

    public DefaultCardAccessor(ComalaPropertiesSetManager contentPropertyManager) {
        this.contentPropertyManager = contentPropertyManager;
    }

    @Override
    public List<Card> getCards(ContentEntityObject ceo, String key) {
        String json = this.contentPropertyManager.getTextProperty(ceo, this.makeKey(key));
        if (!StringUtils.isNotBlank((CharSequence)json)) {
            return new ArrayList<Card>();
        }
        if (json.contains("\"title\":")) {
            log.warn("replacing old json tags");
            json = json.replaceAll("\"title\":", "\"body\":");
        }
        log.debug(String.format("\n cards (json) on page '%s' for container '%s' : %s", ceo.getTitle(), key, json));
        try {
            return CardsUtils.fromJson(json);
        }
        catch (Exception e) {
            log.error("Error parsing\n" + json);
            return new ArrayList<Card>();
        }
    }

    @Override
    public void saveCards(ContentEntityObject ceo, String key, List<Card> cards) {
        String json = CardsUtils.toJson(cards);
        String storageKey = this.makeKey(key);
        this.contentPropertyManager.setTextProperty(ceo, storageKey, json);
        log.debug(String.format("\n saved cards %s under key %s on page %s", json, key, ceo.getTitle()));
    }

    @Override
    public void removeCards(ContentEntityObject ceo, String key) {
        String storageKey = this.makeKey(key);
        this.contentPropertyManager.removeProperty(ceo, storageKey);
    }

    private String makeKey(String key) {
        return CARDS_PREFIX + CardsUtils.normalizeKey(key);
    }
}

