/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.boards.view.model;

import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.comalatech.confluence.adhoclists.boards.view.model.ResolvedContainer;
import com.comalatech.confluence.boards.model.Board;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ResolvedBoard {
    Board board;
    public List<Row> rows;

    public ResolvedBoard(Board board) {
        this.board = board;
        this.rows = new ArrayList<Row>();
    }

    public Row addRow(String header, String footer) {
        Row row = new Row(header, footer);
        this.rows.add(row);
        return row;
    }

    public ResolvedBoard setMoveCaptions() {
        if (this.rows.size() <= 1) {
            return this;
        }
        try {
            Row first = null;
            for (Row row : this.rows) {
                int i = 0;
                for (Column column : row) {
                    for (ResolvedContainer container : column) {
                        if (this.isSet(container.getCaption())) {
                            container.setMoveCaption(container.getCaption());
                            continue;
                        }
                        if (this.isSet(column.getHeader())) {
                            container.setMoveCaption(column.getHeader());
                            continue;
                        }
                        if (first != null && first.size() == row.size()) {
                            Column top = (Column)first.get(i);
                            if (this.isSet(top.getHeader())) {
                                container.setMoveCaption(top.getHeader());
                                continue;
                            }
                            container.setMoveCaption(container.getKey());
                            continue;
                        }
                        container.setMoveCaption(container.getKey());
                    }
                    ++i;
                }
                if (first != null) continue;
                first = row;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    private boolean isSet(String str) {
        return str != null && str.trim().length() > 0;
    }

    public Board getBoard() {
        return this.board;
    }

    public List<Row> getRows() {
        return this.rows;
    }

    public class Row
    extends ArrayList<Column> {
        private String header;
        private String footer;

        public Row(String header, String footer) {
            this.header = header;
            this.footer = footer;
        }

        public Column addColumn(String header, String footer) {
            Column column = new Column(header, footer);
            this.add(column);
            return column;
        }

        public int getColumnWidth() {
            return 100 / this.size();
        }

        @HtmlSafe
        public String getHeader() {
            return HtmlUtil.htmlEncode((String)this.header);
        }

        @HtmlSafe
        public String getFooter() {
            return HtmlUtil.htmlEncode((String)this.footer);
        }
    }

    public class Column
    extends ArrayList<ResolvedContainer> {
        private String header;
        private String footer;

        public Column(String header, String footer) {
            this.header = header;
            this.footer = footer;
        }

        @HtmlSafe
        public String getHeader() {
            if (!StringUtils.isNotBlank((CharSequence)this.header)) {
                return null;
            }
            return HtmlUtil.htmlEncode((String)this.header);
        }

        @HtmlSafe
        public String getFooter() {
            if (!StringUtils.isNotBlank((CharSequence)this.footer)) {
                return null;
            }
            return HtmlUtil.htmlEncode((String)this.footer);
        }
    }
}

