/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

Canvas = Canvas || {};
Canvas.View = Canvas.View || {};
Canvas.View.TableListings = Backbone.View.extend({

    className: "dialog-panel-body panel-body boardlistings loading hidden",
    model: Canvas.Model.Category,
    template: Canvas.Picker.categoryHeading,

    events: {
        "panel.select" : "select"
    },

    initialize: function() {
        this.tableListings = new Canvas.Collection.Tables([],this.model);
        this.tableListings.bind("reset",this.renderBoards,this);
    },

    render: function() {
        return this;
    },

    select: function(event,menuItem) {
        Canvas.AppView.history.navigate('category/' + this.model.get("id"));
        Canvas.AppView.disableInsert();
        this.menuItem = menuItem;
        if (! this.loaded) {
                this.tableListings.fetch();
        } else if (this.menuItem) {
            this.menuItem.$el.removeClass("loading");
        }
        if (this.model.collection && this.model.collection.exchange) {
            Canvas.CML.analytics.trackPage('category/' + this.model.get("id"));
        }
    },

    renderBoards: function() {
        this.$el.removeClass("loading");
        this.$el.append(this.template({
            category: this.model.get("name"),
            description: this.model.get("description")
        }));
        this.tableListings.each(function(tableListing) {
            var listingView = new Canvas.View.TableListing({
                model: tableListing,
                category: this.model.get("name")
            });
            this.$el.append(listingView.render().el);
        },this);
        this.loaded = true;
        if (this.menuItem) {
            this.menuItem.$el.removeClass("loading");
        }
    }

});