/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var Canvas = Canvas || {};
Canvas.Model = Canvas.Model || {};
Canvas.Model.Filter = Backbone.Model.extend({

    defaults: {
        depth: 0,
        parent: "@self",
        labels: "",
        spaceKey: ""
    },

    validate: function(attributes) {
        var errors = [];
        if (attributes.labels && attributes.labels.length > 0) {
            if (! this.isValidLabel(attributes.labels)) {
                errors.push({
                    field: "labels",
                    message : AJS.I18n.getText("adhoclists.boards.designer.error.invalid-label")});
            }
        }
        if (errors.length > 0) {
            return errors;
        }
    },

    isValidLabel : function( label ){
        if (! label || label.length == 0) {
            return false;
        }
        var uppercaseOrSpacePattern = /[A-Z\s]/g;
        var isSpecialCharacter = label.match(/[:;\.?&\[\]\(\)#\^@!<>~\*]+/i) != null;
        var isUpperCaseAndSpace = uppercaseOrSpacePattern.test( label );
        return !isSpecialCharacter && !isUpperCaseAndSpace;
    }

});