/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

(function ($) {
    var LabelDialog = Canvas.CML.Dialog.extend({
        get: function (key) {
            return this.model.get(key)
        },
        set: function (key, value) {
            this.model.set(key, value);
        },
        doFillLabels: function () {
            doFillLabels(this.get('label'), this.get('action'), this.get('pageIds'), this.get('done'));
        },
        setContent: function (content) {
            this.options.content = content;
        }
    });

    if (Canvas.initialized("checklistsops")) {
        return;
    }

    var replaceLabelDialog, addLabelDialog, removeLabelDialog;

    var closeDialog = function(dialog) {
        if (dialog.get('done')){
            dialog.get('done')();
        }
        dialog.hide();
    };

    var createReplaceDialog = function() {
        var dialog = new LabelDialog({
            model: new Backbone.Model(),
            id: "replaceLabelDialog",
            size: 'small',
            title: AJS.I18n.getText("adhoclists.list.label.change.header"),
            actions: [
                {
                    id: 'submit',
                    style: 'primary',
                    label: AJS.I18n.getText("adhoclists.continue"),
                    onClick: function() {
                        var newLabel = $("#changelabelto").val();
                        var oldLabel = dialog.get('label');
                        if (Adhoc.common.isValidLabel(newLabel)) {
                            dialog.setContent(
                                Adhoc.sanitizeBoardContent(
                                    AJS.template.load("label-progress-template")
                                        .fill({
                                            oldLabel: oldLabel,
                                            newLabel: newLabel
                                        }).toString()));
                            setTimeout(function() {
                                doReplaceLabel(dialog, oldLabel, newLabel);
                            },10);
                        } else {
                            Adhoc.common.errorMessage($("#" + dialog.id),AJS.I18n.getText("adhoclists.boards.designer.error.invalid-label"),3000);
                        }
                        return false;
                    }
                },
                {
                    id: 'cancel',
                    style: 'link',
                    label: AJS.I18n.getText("adhoclists.cancel"),
                    onClick: function() {
                        closeDialog(dialog);
                    }
                },
            ]
        })
        return dialog;
    };

    var openReplaceDialog = function($header) {
        var oldLabel = $header.attr("label");
        replaceLabelDialog.set({label: oldLabel});
        replaceLabelDialog.setContent(Adhoc.sanitizeBoardContent(AJS.template.load("change-label-template").fill({label: oldLabel}).toString()));
        replaceLabelDialog.show();
    };

    var doReplaceLabel = function(dialog, oldLabel, newLabel) {
        // var $body = $(".progress",$(dialog.getCurPanel().page.body));
       var ok = true;
       if ( oldLabel == newLabel ){
        //    Adhoc.common.errorMessage($(dialog.getCurPanel().page.body),AJS.I18n.getText("adhoclists.list.label.replace.error.same"));
           setTimeout(function() {
               dialog.hide();
           },2000);
       } else {
           $("tbody.rows tr." + oldLabel + "_label").each(function() {
               var $row = $(this);
               var $cellValue = $('div[label="' + oldLabel + '"]',$row);
            //    $(".progress",$body).html($("a.pagelink",$row).text());
               if (ok) {
                   $.ajax({
                       type: "POST",
                       cache: false,
                       contentType: "application/json",
                       url: AJS.Confluence.getContextPath() + "/rest/adhoclists/latest/lists/label/" +
                               $row.attr("pageid") + "/toggle?label=" + encodeURIComponent(newLabel) +
                               "&labels=" + encodeURIComponent(oldLabel),
                       success: function (action, textStatus, jqXHR) {
                           $cellValue.removeClass("active");
                           $row.removeClass(oldLabel + "_label");
                           $row.addClass(newLabel + "_label");
                           if ($(".list-popularlabels").length > 0) {
                               history.go(0);
                           }
                       },
                       error: function(jqXHR, textStatus, errorThrown) {
                           ok = false;
                           Adhoc.common.errorHandler($body,jqXHR, textStatus,errorThrown);
                       },
                       async: false
                   });
               }
           });
           dialog.hide();
       }
    };

    var createFillDialog = function(action, heading, templateName) {
        // new
        var dialog = new LabelDialog({
            model: new Backbone.Model({
                action: action,
                templateName: templateName,
            }),
            id: action + "LabelActionDialog",
            size: 'small',
            title: heading,
            actions: [
                {
                    id: 'submit',
                    style: 'primary',
                    label: AJS.I18n.getText("adhoclists.continue"),
                    onClick: function () {
                        setTimeout(function() {
                            dialog.doFillLabels();
                            dialog.hide();
                        }, 10);
                    }
                },
                {
                    id: 'cancel',
                    style: 'link',
                    label: AJS.I18n.getText("adhoclists.cancel"),
                    onClick: function() {
                        closeDialog(dialog);
                    }
                },
            ]
        });
        return dialog;
    };

    var openFillDialog = function ($header, dialog) {
        var label = $header.attr("label");
        dialog.setContent(Adhoc.sanitizeBoardContent(AJS.template.load(dialog.get('templateName')).fill({label: label}).toString()));
        setTimeout(() => { dialog.show() }, 100);
    };

    var doFillLabels = function(label, action, pageIds, done) {
        var deferredAjax = [];
        $.each(pageIds, function (idx, pageId) {
            deferredAjax.push(
                $.ajax({
                    type: "POST",
                    cache: false,
                    contentType: "application/json",
                    url: AJS.Confluence.getContextPath() + "/rest/adhoclists/latest/lists/label/" +
                    pageId +
                    "/" + action + "?label=" + encodeURIComponent(label),
                    success: function (action, textStatus, jqXHR) {
                    },
                    error: function (jqXHR, textStatus, errorThrown) {
                        Adhoc.common.errorHandler($row, jqXHR, textStatus, errorThrown);
                    }
                })
            );
        });

        $.when.apply($, deferredAjax).done(function(){
            if(done){
                done();
            }
        });

    };

    var getPageIds = function ($table, selector) {
        var pageIds = [];
        $(selector, $table).each(function () {
            pageIds.push($(this).attr("pageid"));
        });
        return pageIds;
    };

    var reloadList = function ($table) {
        return function () {
            var $moreRows = $("tr.morerows", $table);
            $moreRows.attr("rows", "0");
            $moreRows.attr("start", "0");
            $("tbody.rows", $table).empty();
            Adhoc.Checklist.loadRows($("tr.morerows td div", $table));
        };
    };

    AJS.toInit(function ($) {
        AJS.log("init checklists");

        // replace labels
        replaceLabelDialog = createReplaceDialog();
        $(".changelabel").on("click", function(event) {
            event.preventDefault();
            var $dropdown = $(this).closest('.aui-dropdown2');
            var $trigger = $('button[aria-controls=' + $dropdown.attr('id') + ']');
            var $header = $trigger.parents("th");
            openReplaceDialog($header);
        });

        // filling labels
        addLabelDialog = createFillDialog("add",AJS.I18n.getText("adhoclists.list.label.fill.add.header"),"fill-label-add-confirm-template");
        removeLabelDialog = createFillDialog("remove",AJS.I18n.getText("adhoclists.list.label.fill.remove.header"),"fill-label-remove-confirm-template");
        $(".filllabel.add").click(function(event) {
            event.preventDefault();
            var $dropdown = $(this).closest('.aui-dropdown2');
            var $trigger = $('button[aria-controls=' + $dropdown.attr('id') + ']');
            var $header = $trigger.parents("th");
            var $table = $trigger.parents(".checklistwrapper");
            var label = $header.attr("label");

            addLabelDialog.set({
                label: label,
                pageIds: getPageIds($table, "tbody.rows>tr:not(." + label + "_label)"),
                done: reloadList($table)
            })
            $("tbody.rows",$table).empty(); // this is purely to kill the dropdown next to the column header

            openFillDialog($header, addLabelDialog);
        });

        $(".filllabel.remove").click(function(event) {
            event.preventDefault();
            var $dropdown = $(this).closest('.aui-dropdown2');
            var $trigger = $('button[aria-controls=' + $dropdown.attr('id') + ']');
            var $header = $trigger.parents("th");
            var $table = $trigger.parents(".checklistwrapper");
            var label =  $header.attr("label");

            removeLabelDialog.set({
                label: label,
                pageIds: getPageIds($table, "tbody.rows>tr." + label + "_label"),
                done: reloadList($table)
            });
            $("tbody.rows",$table).empty();

            openFillDialog($header,removeLabelDialog,"remove");
        });

    });
})(AJS.$);
