/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var Adhoc = Adhoc || {};
Adhoc.Checklist = Adhoc.Checklist || {};
var Canvas = Canvas || {};

// We are associating a column 'object' to the column header (i.e. 'table.adhocchecklist tr.headings th')
// to integrate the jQuery element to the Column's properties
(function ($) {
    if (Canvas.initialized && Canvas.initialized("checklists.designer.core")) {
        return;
    }

    $.fn.extend({

        setColumn: function(column) {
            $(this).data("column",column);
            var type;
            for ( type in column) {
                break;
            }
            $(this).data("type",type);
        },

        getColumnInfo: function() {
            var columnInfo = {};
            if ($(this).hasClass("column")) {
                return $(this).data("column");
            } else if ($(this).hasClass("aui.checklist")) {
                return (this).data("column");
            } else if ($(this).parents("form.aui.checklist").length == 1) {
                return $(this).parents("form.aui.checklist").data("column");
            }
            if ($(this).hasClass("heading")) {
                columnInfo.$heading = $(this);
            } else {
                columnInfo.$heading = $(this).parents("th.heading");
            }
            columnInfo.column = columnInfo.$heading.data("column");
            columnInfo.type = columnInfo.$heading.data("type");
            var type = columnInfo.type;
            columnInfo.toJson = function() {
                return JSON.stringify(columnInfo.column[type]);
            };
            columnInfo.resetHeading = function() {
                // will reset the heading (title, width, style) with the column's propertis
                var header = AJS.escapeHtml(columnInfo.column[columnInfo.type].header);
                columnInfo.$heading.find("td.caption").html(header);
            };
            columnInfo.setAttributes = function($form) {
                // sets the column's object properties with the values provided in the form
                var header = $("#column-header").val();
                var cssclass = $("#cssclass").val();
                var width = $("#width").val();
                columnInfo.column[type].width = width;
                columnInfo.column[type].style = cssclass;
                columnInfo.column[type].header = header;
            };
            return columnInfo;
        }

    });

    Adhoc.Checklist.toJson = function() {
        return JSON.stringify(Adhoc.Checklist.checklist);
    };

    Adhoc.Checklist.update = function() {
        Adhoc.Checklist.checklist.name = $("#checklistname").val();
        Adhoc.Checklist.checklist.maxRows = $("#checklistmaxrows").val();
        Adhoc.Checklist.checklist.leftJustified = $("#checklistCentered:checked").length == 0;
        Adhoc.Checklist.checklist.templateName = $("#checklistTemplateName option:selected").val();
        Adhoc.Checklist.checklist.columns = [];
        var sortType = {order:$("input[name='ascending']:checked").val(),
                        sortBy:$("#checklistsorttype option:selected").val()};

        Adhoc.Checklist.checklist.sortType = sortType;
        $("table.adhocchecklist tr.headings th.heading:not(.new)").each(function() {
            var $heading = $(this);
            $heading.removeClass("empty").removeClass("new");
            Adhoc.Checklist.checklist.columns.push($heading.getColumnInfo().column);
        });
    };

    Adhoc.Checklist.init = function() {
        try {
            Adhoc.Checklist.checklist = JSON.parse($(".checklistobject").text());
        } catch (e) {
            AJS.log("error parsing " + $(".checklistobject").text());
        }
        // Associating Table Columns with actual checklist columns
        var i = 0;
        $("table.adhocchecklist tr.headings th.heading").each(function() {
            $(this).setColumn(Adhoc.Checklist.checklist.columns[i++]);
        });
        Adhoc.Checklist.spaceKey = AJS.params.spaceKey;
        // Init tabs
        AJS.tabs.setup();
    }

})(AJS.$);
