/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

(function ($) {
    if (Canvas.initialized("wikinput.cell")) {
        return;
    }

    AJS.toInit(function ($) {
        AJS.log("init wikiinput.cell");
        $(document).on('click', ".adhocchecklist.view .cell-wikiinput .editlink", function() {
            var $cell = $(this).parents(".cell-wikiinput ");
            if ($cell.hasClass("edit")) {
                return;
            }
            $(".cell-wikiinput").removeClass("edit");
            $cell.find(".cell-wikiinput-element").removeClass("hidden");
            $cell.addClass("edit");
            var $input = $cell.find("textarea");
            $input.focus();
        });
        $(document).on('click', ".cell-wikiinput a.cancelinput", function() {
            var $cell = $(this).parents("td.cell-wikiinput");
            $cell.removeClass("edit");
            $cell.find(".cell-wikiinput-element").addClass("hidden");
            return false;
        });
        $(document).on('click', ".cell-wikiinput input.acceptinput", function() {
            var $cell = $(this).parents("td.cell-wikiinput");
            var pageId = Adhoc.Checklist.rowId($cell);
            var $input = $cell.find("textarea");
            var valueName = $input.attr("name");
            var value = $input.val();
            $.ajax({
                type: "POST",
                cache: false,
                data: value,
                contentType: "application/json; charset=utf-8",
                url: AJS.Confluence.getContextPath() + "/rest/adhoclists/latest/lists/metadata/" +
                        pageId + "/set?valueName=" + encodeURIComponent(valueName)+"&renderWikiMarkup=true",
                success: function (action, textStatus, jqXHR) {
                    $cell.find(".cell-value").html(action);
                    $cell.removeClass("edit");
                    $cell.find(".cell-wikiinput-element").addClass("hidden");
                    $(".adhocchecklist.view").trigger("update");
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    Adhoc.common.errorHandler($cell.parents("tr.page"),jqXHR, textStatus,errorThrown);
                }
            });
            return false;
        });

        $(document).on('resetcell', "tr.newpagerow td.cell-wikiinput", function(event) {
            $("textarea",$(this)).val("");
        });
        $(document).on('initcell', "tr.newpagerow td.cell-wikiinput", function(event,$newrow) {
            var $cell = $(this);
            var $newCell = $("td:nth-child(" + $cell.attr("index") + ")",$newrow);
            var value = $("textarea",$cell).val();
            if (value && value.length > 0) {
                $("textarea",$newCell).val(value);
                $("input.acceptinput",$newCell).click();
            }
        });
    });
})(AJS.$);
