/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.boards.util;

import com.atlassian.confluence.labels.Label;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class BoardUtils {
    private static final String INVALID_CHARS_FOR_LABELS_REGEXP = "[()!#&*,.:;<>?@\\[\\]^\\s]";
    private static final String SELF_CLOSING_AT_DECLARATIONS_TAG = "<at:declarations />";

    public static String generateContainerIdFromLabels(String[] labels) {
        return Arrays.stream(labels).filter(label -> StringUtils.isNotBlank((CharSequence)label)).map(String::trim).collect(Collectors.joining(","));
    }

    public static List<Label> getLabelsFromContainerId(String containerId) {
        return Arrays.stream(containerId.split(",")).filter(label -> StringUtils.isNotBlank((CharSequence)label)).map(label -> new Label(label.trim())).collect(Collectors.toList());
    }

    public static String extractUsernameFromString(String text) {
        String[] words;
        for (String w : words = text.split(" ")) {
            if (!w.startsWith("@")) continue;
            return w.substring(1);
        }
        return "";
    }

    public static String getPersonalPageLabelFromUsername(String username) {
        String transformedUsername = username.replaceAll("\\.|@", "_");
        return StringUtils.removeAll((String)transformedUsername, (String)INVALID_CHARS_FOR_LABELS_REGEXP);
    }

    public static String cleanPageContentFor(String contentToClean) {
        return StringUtils.removeStart((String)contentToClean, (String)SELF_CLOSING_AT_DECLARATIONS_TAG);
    }
}

