/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.boards.rest;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugins.rest.common.security.UnrestrictedAccess;
import com.atlassian.sal.api.message.I18nResolver;
import com.comalatech.confluence.adhoclists.boards.BoardValidator;
import com.comalatech.confluence.adhoclists.boards.view.model.RenderedCard;
import com.comalatech.confluence.adhoclists.condition.RestCondition;
import com.comalatech.confluence.adhoclists.rest.PermissionRequired;
import com.comalatech.confluence.adhoclists.storage.serializer.BoardJsonSerializer;
import com.comalatech.confluence.boards.exception.ComalaBoardsRestException;
import com.comalatech.confluence.boards.model.Board;
import com.comalatech.confluence.boards.rest.BoardResourcesValidator;
import com.comalatech.confluence.boards.rest.NewAbstractRestResources;
import com.comalatech.confluence.boards.rest.model.BoardCards;
import com.comalatech.confluence.boards.rest.model.CardsRequest;
import com.comalatech.confluence.boards.rest.model.NewCard;
import com.comalatech.confluence.boards.rest.model.PageBasicInfo;
import com.comalatech.confluence.boards.service.BoardService;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="/boards")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class NewBoardResources
extends NewAbstractRestResources
implements BoardResourcesValidator {
    private final BoardService boardService;
    private final BoardJsonSerializer boardJsonSerializer;

    @Autowired
    public NewBoardResources(PageManager pageManager, SpaceManager spaceManager, PermissionManager permissionManager, I18nResolver i18nResolver, RestCondition restCondition, BoardValidator boardValidator, BoardService boardService, BoardJsonSerializer boardJsonSerializer) {
        super(pageManager, spaceManager, permissionManager, i18nResolver, restCondition, boardValidator);
        this.boardService = boardService;
        this.boardJsonSerializer = boardJsonSerializer;
    }

    @POST
    @Path(value="/{abstractPageId}/card")
    @PermissionRequired(permissionTypes={PermissionRequired.Type.EDIT, PermissionRequired.Type.SHOWBOARD})
    @UnrestrictedAccess
    public Response addPlainCard(@PathParam(value="abstractPageId") Long abstractPageId, final NewCard card) {
        return new NewAbstractRestResources.AbstractPageRestCommand(){

            @Override
            protected Response doInCommand(AbstractPage abstractPage) {
                if (NewBoardResources.this.isValidPlainCardPayload(card)) {
                    RenderedCard renderedCard = NewBoardResources.this.boardService.addPlainCardToBoard(abstractPage, card);
                    return Response.ok().entity((Object)renderedCard).build();
                }
                throw new ComalaBoardsRestException(Response.Status.BAD_REQUEST.getStatusCode(), NewBoardResources.this.i18nResolver.getText("comala-boards.exceptions.rest.request.wrong-payload"));
            }
        }.execute(abstractPageId);
    }

    @PUT
    @Path(value="/{abstractPageId}/cards")
    @PermissionRequired(permissionTypes={PermissionRequired.Type.EDIT, PermissionRequired.Type.SHOWBOARD})
    @UnrestrictedAccess
    public Response addPlainCards(@PathParam(value="abstractPageId") Long abstractPageId, final NewCard[] cards) {
        return new NewAbstractRestResources.AbstractPageRestCommand(){

            @Override
            protected Response doInCommand(AbstractPage abstractPage) {
                if (NewBoardResources.this.isValidPlainCardsPayload(cards)) {
                    NewBoardResources.this.boardService.addPlainCardsToBoard(abstractPage, cards);
                    return Response.ok().build();
                }
                if (cards != null && cards.length > 100) {
                    throw new ComalaBoardsRestException(Response.Status.BAD_REQUEST.getStatusCode(), NewBoardResources.this.i18nResolver.getText("comala-boards.exceptions.rest.request.too-many-cards", new Serializable[]{Integer.valueOf(100)}));
                }
                throw new ComalaBoardsRestException(Response.Status.BAD_REQUEST.getStatusCode(), NewBoardResources.this.i18nResolver.getText("comala-boards.exceptions.rest.request.wrong-payload"));
            }
        }.execute(abstractPageId);
    }

    @POST
    @Path(value="/{abstractPageId}/update-card")
    @PermissionRequired(permissionTypes={PermissionRequired.Type.EDIT, PermissionRequired.Type.SHOWBOARD})
    @UnrestrictedAccess
    public Response updatePlainCard(@PathParam(value="abstractPageId") Long abstractPageId, final NewCard[] cards) {
        return new NewAbstractRestResources.AbstractPageRestCommand(){

            @Override
            protected Response doInCommand(AbstractPage abstractPage) {
                if (NewBoardResources.this.isValidPlainCardsForUpdating(cards)) {
                    RenderedCard renderedCard = NewBoardResources.this.boardService.updatePlainCards(abstractPage, cards);
                    return Response.ok().entity((Object)renderedCard).build();
                }
                throw new ComalaBoardsRestException(Response.Status.BAD_REQUEST.getStatusCode(), NewBoardResources.this.i18nResolver.getText("comala-boards.exceptions.rest.request.wrong-payload"));
            }
        }.execute(abstractPageId);
    }

    @DELETE
    @Path(value="/{abstractPageId}/card")
    @PermissionRequired(permissionTypes={PermissionRequired.Type.EDIT, PermissionRequired.Type.SHOWBOARD})
    @UnrestrictedAccess
    public Response deletePlainCard(@PathParam(value="abstractPageId") Long abstractPageId, final NewCard card) {
        return new NewAbstractRestResources.AbstractPageRestCommand(){

            @Override
            protected Response doInCommand(AbstractPage abstractPage) {
                if (!NewBoardResources.this.isValidPlainCardPayload(card)) {
                    throw new ComalaBoardsRestException(Response.Status.BAD_REQUEST.getStatusCode(), NewBoardResources.this.i18nResolver.getText("comala-boards.exceptions.rest.request.wrong-payload"));
                }
                NewBoardResources.this.boardService.deletePlainCardFromBoard(abstractPage, card);
                return Response.ok().build();
            }
        }.execute(abstractPageId);
    }

    @DELETE
    @Path(value="/{abstractPageId}/clear-board")
    @PermissionRequired(permissionTypes={PermissionRequired.Type.EDIT, PermissionRequired.Type.SHOWBOARD})
    @UnrestrictedAccess
    public Response clearBoard(@PathParam(value="abstractPageId") Long abstractPageId, final String boardMarkup) {
        return new NewAbstractRestResources.AbstractPageRestCommand(){

            @Override
            protected Response doInCommand(AbstractPage abstractPage) {
                Board board;
                if (StringUtils.isNotBlank((CharSequence)boardMarkup)) {
                    board = (Board)NewBoardResources.this.boardJsonSerializer.deserialize(boardMarkup);
                    if (board == null) {
                        throw new ComalaBoardsRestException(Response.Status.BAD_REQUEST.getStatusCode(), NewBoardResources.this.i18nResolver.getText("comala-boards.exceptions.rest.request.board-parsing-error", new Serializable[]{boardMarkup}));
                    }
                } else {
                    throw new ComalaBoardsRestException(Response.Status.BAD_REQUEST.getStatusCode(), NewBoardResources.this.i18nResolver.getText("comala-boards.exceptions.rest.request.wrong-payload"));
                }
                NewBoardResources.this.boardService.clearBoard(abstractPage, board);
                return Response.ok().build();
            }
        }.execute(abstractPageId);
    }

    @PUT
    @Path(value="/{abstractPageId}/page")
    @PermissionRequired(permissionTypes={PermissionRequired.Type.EDIT, PermissionRequired.Type.SHOWBOARD})
    @UnrestrictedAccess
    public Response addPageCard(@PathParam(value="abstractPageId") Long abstractPageId, final NewCard card, final @QueryParam(value="templateId") Long templateId) {
        return new NewAbstractRestResources.AbstractPageRestCommand(){

            @Override
            protected Response doInCommand(AbstractPage abstractPage) {
                if (!NewBoardResources.this.isValidCardPayload(card)) {
                    throw new ComalaBoardsRestException(Response.Status.BAD_REQUEST.getStatusCode(), NewBoardResources.this.i18nResolver.getText("comala-boards.exceptions.rest.request.wrong-payload"));
                }
                RenderedCard renderedCard = NewBoardResources.this.boardService.addPageCardToBoard(abstractPage, card, templateId);
                return Response.ok().entity((Object)renderedCard).build();
            }
        }.execute(abstractPageId);
    }

    @DELETE
    @Path(value="/{abstractPageId}/page")
    @PermissionRequired(permissionTypes={PermissionRequired.Type.EDIT, PermissionRequired.Type.SHOWBOARD})
    @UnrestrictedAccess
    public Response deletePageCard(@PathParam(value="abstractPageId") Long abstractPageId, final NewCard card) {
        return new NewAbstractRestResources.AbstractPageRestCommand(){

            @Override
            protected Response doInCommand(AbstractPage abstractPage) {
                if (!NewBoardResources.this.isValidPageCardPayload(card)) {
                    throw new ComalaBoardsRestException(Response.Status.BAD_REQUEST.getStatusCode(), NewBoardResources.this.i18nResolver.getText("comala-boards.exceptions.rest.request.wrong-payload"));
                }
                NewBoardResources.this.boardService.deletePageCardFromBoard(abstractPage, card);
                return Response.ok().build();
            }
        }.execute(abstractPageId);
    }

    @POST
    @Path(value="/{abstractPageId}/card-to-page")
    @PermissionRequired(permissionTypes={PermissionRequired.Type.EDIT, PermissionRequired.Type.SHOWBOARD})
    @UnrestrictedAccess
    public Response convertPlainCardToPageCard(@PathParam(value="abstractPageId") Long abstractPageId, final NewCard card, final @QueryParam(value="templateId") Long templateId) {
        return new NewAbstractRestResources.AbstractPageRestCommand(){

            @Override
            protected Response doInCommand(AbstractPage abstractPage) {
                if (!NewBoardResources.this.isValidPlainCardPayload(card)) {
                    throw new ComalaBoardsRestException(Response.Status.BAD_REQUEST.getStatusCode(), NewBoardResources.this.i18nResolver.getText("comala-boards.exceptions.rest.request.wrong-payload"));
                }
                RenderedCard renderedCard = NewBoardResources.this.boardService.convertPlainCardToPageCard(abstractPage, card, templateId);
                return Response.ok().entity((Object)renderedCard).build();
            }
        }.execute(abstractPageId);
    }

    @POST
    @Path(value="/{abstractPageId}/move-card")
    @PermissionRequired(permissionTypes={PermissionRequired.Type.EDIT, PermissionRequired.Type.SHOWBOARD})
    @UnrestrictedAccess
    public Response moveCard(@PathParam(value="abstractPageId") Long abstractPageId, final NewCard[] cards, final @QueryParam(value="notify") boolean notify) {
        return new NewAbstractRestResources.AbstractPageRestCommand(){

            @Override
            protected Response doInCommand(AbstractPage abstractPage) {
                if (!NewBoardResources.this.isValidCardsForMoving(cards)) {
                    throw new ComalaBoardsRestException(Response.Status.BAD_REQUEST.getStatusCode(), NewBoardResources.this.i18nResolver.getText("comala-boards.exceptions.rest.request.wrong-payload"));
                }
                NewBoardResources.this.boardService.moveCard(abstractPage, cards[0], cards.length == 2 ? cards[1] : null, notify);
                return Response.ok().build();
            }
        }.execute(abstractPageId);
    }

    @POST
    @Path(value="/{abstractPageId}/cards")
    @PermissionRequired(permissionTypes={PermissionRequired.Type.VIEW, PermissionRequired.Type.SHOWBOARD})
    @UnrestrictedAccess
    @ReadOnlyAccessAllowed
    public Response getCards(@PathParam(value="abstractPageId") Long abstractPageId, final CardsRequest cardsRequest) {
        return new NewAbstractRestResources.AbstractPageRestCommand(){

            @Override
            protected Response doInCommand(AbstractPage abstractPage) {
                if (cardsRequest != null) {
                    Board board = (Board)NewBoardResources.this.boardJsonSerializer.deserialize(cardsRequest.getBoardMarkup());
                    if (board != null) {
                        BoardCards boardCards = NewBoardResources.this.boardService.resolveBoardCards(abstractPage, board, cardsRequest.getContainerIds(), cardsRequest.getStartIndex());
                        return Response.ok().entity((Object)boardCards).build();
                    }
                    throw new ComalaBoardsRestException(Response.Status.BAD_REQUEST.getStatusCode(), NewBoardResources.this.i18nResolver.getText("comala-boards.exceptions.rest.request.board-parsing-error", new Serializable[]{cardsRequest.getBoardMarkup()}));
                }
                throw new ComalaBoardsRestException(Response.Status.BAD_REQUEST.getStatusCode(), NewBoardResources.this.i18nResolver.getText("comala-boards.exceptions.rest.request.wrong-payload"));
            }
        }.execute(abstractPageId);
    }

    @GET
    @Path(value="/{spaceKey}/templates")
    @PermissionRequired(permissionTypes={PermissionRequired.Type.VIEW, PermissionRequired.Type.SHOWBOARD})
    @UnrestrictedAccess
    public Response getTemplates(@PathParam(value="spaceKey") String spaceKey) {
        return new NewAbstractRestResources.SpaceRestCommand(){

            @Override
            protected Response doInCommand(Space space) {
                Map<String, List<PageBasicInfo>> templates = NewBoardResources.this.boardService.getAvailablePageTemplates(space);
                return Response.ok().entity(templates).build();
            }
        }.execute(spaceKey);
    }

    @POST
    @Path(value="/{abstractPageId}/search-pages")
    @PermissionRequired(permissionTypes={PermissionRequired.Type.VIEW, PermissionRequired.Type.SHOWBOARD})
    @UnrestrictedAccess
    @ReadOnlyAccessAllowed
    public Response searchPages(@PathParam(value="abstractPageId") Long abstractPageId, final @QueryParam(value="text") String text, final @QueryParam(value="searchAllSpaces") boolean searchAllSpaces, final String boardMarkup) {
        return new NewAbstractRestResources.AbstractPageRestCommand(){

            @Override
            protected Response doInCommand(AbstractPage abstractPage) {
                if (StringUtils.isNotBlank((CharSequence)boardMarkup) && text.length() > 2) {
                    Board board = (Board)NewBoardResources.this.boardJsonSerializer.deserialize(boardMarkup);
                    if (board != null) {
                        return Response.ok().entity(NewBoardResources.this.boardService.searchPagesByTitleAndFilter(abstractPage, text, board.getFilter(), searchAllSpaces)).build();
                    }
                    throw new ComalaBoardsRestException(Response.Status.BAD_REQUEST.getStatusCode(), NewBoardResources.this.i18nResolver.getText("comala-boards.exceptions.rest.request.board-parsing-error", new Serializable[]{boardMarkup}));
                }
                throw new ComalaBoardsRestException(Response.Status.BAD_REQUEST.getStatusCode(), NewBoardResources.this.i18nResolver.getText("comala-boards.exceptions.rest.request.wrong-payload"));
            }
        }.execute(abstractPageId);
    }
}

