/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.boards.model;

import com.atlassian.confluence.labels.Label;
import com.comalatech.confluence.adhoclists.model.TableViewContext;
import com.comalatech.confluence.adhoclists.utils.AdhocListsUtils;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class BoardViewContext
extends TableViewContext {
    public static final int MAX_PAGES_PER_CONTAINER = 20;
    private Set<String> allKeys;
    private List<Label> allLabels;
    private Boolean cardsOnly = null;
    private boolean pageExport = false;
    private boolean hostPageIncluded = false;
    private int count = 20;

    public BoardViewContext(String spaceKey, Set<String> allKeys) {
        super(spaceKey);
        this.allKeys = allKeys;
        this.allLabels = AdhocListsUtils.toLabelList(AdhocListsUtils.keysToLabels(allKeys));
    }

    public BoardViewContext(String spaceKey) {
        super(spaceKey);
    }

    public Set<String> getAllKeys() {
        return this.allKeys;
    }

    public List<Label> getAllLabels() {
        return this.allLabels != null ? this.allLabels : Collections.emptyList();
    }

    public boolean isCardsOnly() {
        return this.cardsOnly == Boolean.TRUE;
    }

    public boolean isCards() {
        return this.cardsOnly == null || this.cardsOnly == Boolean.TRUE;
    }

    public void setCardsOnly() {
        this.cardsOnly = Boolean.TRUE;
    }

    public void setPagesOnly() {
        this.cardsOnly = Boolean.FALSE;
    }

    public boolean isPagesOnly() {
        return this.cardsOnly == Boolean.FALSE;
    }

    public boolean isPages() {
        return this.cardsOnly == null || this.cardsOnly == Boolean.FALSE;
    }

    public void setPagesAndCards() {
        this.cardsOnly = null;
    }

    public boolean isPagesAndCards() {
        return this.cardsOnly == null;
    }

    public boolean isPageExport() {
        return this.pageExport;
    }

    public void setPageExport(boolean pageExport) {
        this.pageExport = pageExport;
    }

    public boolean isHostPageIncluded() {
        return this.hostPageIncluded;
    }

    public void setHostPageIncluded(boolean hostPageIncluded) {
        this.hostPageIncluded = hostPageIncluded;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public boolean isHistoricalPageVersion() {
        return this.getPage() != null && !this.getPage().isLatestVersion();
    }
}

