/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.welcome;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPropertyManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.User;
import com.comalatech.confluence.adhoclists.license.AdhocLicenseManager;
import com.comalatech.confluence.adhoclists.welcome.WelcomeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class WelcomeManagerImpl
implements WelcomeManager,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(WelcomeManagerImpl.class);
    public static final String HIDE_CANVAS_WELCOME_KEY = "com.comalatech.adhoccanvas.hidewelcome";
    private static final String CANVAS_WELCOME_EXPIRATION_PREFIX = "com.comalatech.adhoccanvas.welcomeexpiration.";
    private static final long SHOWING_WELCOME_PERIOD = 259200000L;
    private final PersonalInformationManager personalInformationManager;
    private final BandanaManager bandanaManager;
    private final ContentPropertyManager contentPropertyManager;
    private final TransactionTemplate transactionTemplate;
    private final AdhocLicenseManager licenseManager;
    private final PermissionManager permissionManager;
    private String pluginVersion;
    private long adminWelcomeExpiration = 0L;

    public WelcomeManagerImpl(@ComponentImport ContentPropertyManager contentPropertyManager, @ComponentImport PersonalInformationManager personalInformationManager, @ComponentImport BandanaManager bandanaManager, @ComponentImport TransactionTemplate transactionTemplate, AdhocLicenseManager licenseManager, @ComponentImport PermissionManager permissionManager) {
        this.contentPropertyManager = contentPropertyManager;
        this.personalInformationManager = personalInformationManager;
        this.bandanaManager = bandanaManager;
        this.transactionTemplate = transactionTemplate;
        this.licenseManager = licenseManager;
        this.permissionManager = permissionManager;
    }

    @Override
    public String getWelcomeUrl() {
        return "https://apps.appf.re/cbdc/doc/welcome/qLFj8g?version=" + this.pluginVersion;
    }

    @Override
    public boolean isShowWelcome(ConfluenceUser user) {
        return this.isShowPersonalPreference(user) && this.getWelcomeUrl().toLowerCase().contains("http");
    }

    private boolean isShowPersonalPreference(ConfluenceUser user) {
        if (user == null) {
            return false;
        }
        PersonalInformation pi = this.personalInformationManager.getOrCreatePersonalInformation((User)user);
        return this.contentPropertyManager.getStringProperty((ContentEntityObject)pi, HIDE_CANVAS_WELCOME_KEY) == null;
    }

    @Override
    public boolean isShowAdminWelcome(ConfluenceUser user) {
        return System.currentTimeMillis() <= this.adminWelcomeExpiration && this.permissionManager.isConfluenceAdministrator((User)user);
    }

    public void afterPropertiesSet() throws Exception {
        try {
            this.pluginVersion = this.licenseManager.getCurrentVersion();
            String expiration = (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), CANVAS_WELCOME_EXPIRATION_PREFIX + this.pluginVersion);
            if (expiration != null) {
                this.adminWelcomeExpiration = Long.parseLong(expiration);
            } else {
                this.adminWelcomeExpiration = System.currentTimeMillis() + 259200000L;
                this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

                    public Object doInTransaction() {
                        WelcomeManagerImpl.this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), WelcomeManagerImpl.CANVAS_WELCOME_EXPIRATION_PREFIX + WelcomeManagerImpl.this.pluginVersion, (Object)Long.toString(WelcomeManagerImpl.this.adminWelcomeExpiration));
                        return null;
                    }
                });
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    @Override
    public void setHideWelcome(ConfluenceUser user) {
        if (user == null) {
            return;
        }
        PersonalInformation pi = this.personalInformationManager.getOrCreatePersonalInformation((User)user);
        this.contentPropertyManager.setStringProperty((ContentEntityObject)pi, HIDE_CANVAS_WELCOME_KEY, "true");
    }

    @Override
    public void setShowWelcome(ConfluenceUser user) {
        if (user == null) {
            return;
        }
        PersonalInformation pi = this.personalInformationManager.getOrCreatePersonalInformation((User)user);
        this.contentPropertyManager.removeProperty((ContentEntityObject)pi, HIDE_CANVAS_WELCOME_KEY);
    }
}

