/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.templates;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.adhoclists.utils.AdhocListsUtils;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageTemplateModuleDescriptor
extends AbstractModuleDescriptor<PageTemplate> {
    private static final Logger log = LoggerFactory.getLogger(PageTemplateModuleDescriptor.class);
    protected PageTemplate pageTemplate;
    protected final LabelManager labelManager;

    public PageTemplateModuleDescriptor(@ComponentImport ModuleFactory moduleFactory, @ComponentImport LabelManager labelManager) {
        super(moduleFactory);
        this.labelManager = labelManager;
    }

    public PageTemplate getModule() {
        return this.pageTemplate;
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        String[] labelNames;
        super.init(plugin, element);
        String templateName = this.getAttribute(element, "name");
        if (plugin == null) {
            throw new PluginParseException("Need name");
        }
        String body = element.getData().toString();
        this.pageTemplate = new PageTemplate();
        this.pageTemplate.setName(templateName);
        this.pageTemplate.setDescription(this.getAttribute(element, "description"));
        String commaSeparatedLabels = this.getAttribute(element, "labels");
        this.pageTemplate.setContent(body.trim());
        for (String labelName : labelNames = AdhocListsUtils.splitAndTrim(commaSeparatedLabels)) {
            Label label = new Label(labelName);
            this.labelManager.addLabel((Labelable)this.pageTemplate, label);
        }
    }

    private String getAttribute(Element element, String attributeName) {
        Attribute attribute = element.attribute(attributeName);
        if (attribute == null) {
            return null;
        }
        return attribute.getValue();
    }
}

