/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.storage;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.core.persistence.AnyTypeDao;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.comalatech.confluence.adhoclists.content.ComalaPropertiesSetManager;
import com.comalatech.confluence.adhoclists.lists.model.Checklist;
import com.comalatech.confluence.adhoclists.lists.model.PageValueType;
import com.comalatech.confluence.adhoclists.lists.types.PageColumn;
import com.comalatech.confluence.adhoclists.model.Table;
import com.comalatech.confluence.adhoclists.storage.AbstractTableManager;
import com.comalatech.confluence.adhoclists.storage.AdhocListManager;
import com.comalatech.confluence.adhoclists.storage.ChecklistModuleDescriptor;
import com.comalatech.confluence.adhoclists.storage.serializer.ChecklistJsonSerializer;
import com.comalatech.confluence.adhoclists.storage.serializer.ChecklistXmlSerializer;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import org.springframework.stereotype.Component;

@Component
public class DefaultAdhocListManager
extends AbstractTableManager<Checklist>
implements AdhocListManager {
    private final ChecklistXmlSerializer checklistXmlSerializer;
    private final ChecklistJsonSerializer checklistJsonSerializer;
    private final ComalaI18nBean comalaI18nBean;

    public DefaultAdhocListManager(@ComponentImport BandanaManager bandanaManager, @ComponentImport TransactionTemplate transactionTemplate, @ComponentImport PluginAccessor pluginAccessor, ComalaPropertiesSetManager contentPropertyManager, @ComponentImport SearchManager searchManager, @ComponentImport AnyTypeDao anyTypeDao, @ComponentImport PageManager pageManager, @ComponentImport XhtmlContent xhtmlContent, ChecklistXmlSerializer checklistXmlSerializer, ChecklistJsonSerializer checklistJsonSerializer, ComalaI18nBean comalaI18nBean) {
        super(bandanaManager, transactionTemplate, pluginAccessor, contentPropertyManager, searchManager, anyTypeDao, pageManager, xhtmlContent, comalaI18nBean);
        this.checklistXmlSerializer = checklistXmlSerializer;
        this.checklistJsonSerializer = checklistJsonSerializer;
        this.comalaI18nBean = comalaI18nBean;
    }

    @Override
    public Checklist deserialize(String body) {
        return (Checklist)this.checklistXmlSerializer.deserialize(body);
    }

    @Override
    public String serialize(Checklist template) {
        return this.checklistXmlSerializer.serialize(template);
    }

    @Override
    public Checklist deserializeJson(String body) {
        return (Checklist)this.checklistJsonSerializer.deserialize(body);
    }

    @Override
    public String serializeJson(Checklist template) {
        return this.checklistJsonSerializer.serialize(template);
    }

    @Override
    public String getBandanaKey() {
        return "com.comalatech.adhoclists.checklists";
    }

    @Override
    protected String serializeMock(Table mock) {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    protected Table deserializeMock(String mock) {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    public String getMacroName() {
        return "adhoclist";
    }

    @Override
    public Checklist makeEmpty() {
        Checklist checklist = new Checklist();
        checklist.addColumn(new PageColumn(PageValueType.Type.VIEWLINK));
        checklist.setName(this.comalaI18nBean.getText("adhoclists.rte.lists.select.new"));
        return checklist;
    }

    @Override
    protected Class getDescriptorClass() {
        return ChecklistModuleDescriptor.class;
    }

    @Override
    protected String getDefaultNewTableName() {
        return this.comalaI18nBean.getText("adhoclists.rte.lists.select.new");
    }
}

