/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.storage;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.persistence.AnyTypeDao;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.v2.BooleanOperator;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.search.v2.query.ContentTypeQuery;
import com.atlassian.confluence.search.v2.query.InSpaceQuery;
import com.atlassian.confluence.search.v2.query.TextFieldQuery;
import com.atlassian.confluence.search.v2.sort.ModifiedSort;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.confluence.xhtml.api.MacroDefinitionHandler;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.renderer.RenderContext;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.comalatech.confluence.adhoclists.content.ComalaPropertiesSetManager;
import com.comalatech.confluence.adhoclists.model.Table;
import com.comalatech.confluence.adhoclists.storage.TableManager;
import com.comalatech.confluence.adhoclists.storage.TableModuleDescriptor;
import com.comalatech.confluence.adhoclists.utils.ComalaContentSearch;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTableManager<T extends Table>
implements TableManager<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractTableManager.class);
    private static final String PROPERTY_KEY = "adhoccanvas.cards.";
    private static final List<ContentTypeEnum> CONTENT_TYPES = Arrays.asList(ContentTypeEnum.PAGE, ContentTypeEnum.BLOG);
    private final BandanaManager bandanaManager;
    private final TransactionTemplate transactionTemplate;
    private final PluginAccessor pluginAccessor;
    private final ComalaPropertiesSetManager contentPropertyManager;
    private final SearchManager searchManager;
    private final AnyTypeDao anyTypeDao;
    private final PageManager pageManager;
    private final XhtmlContent xhtmlContent;
    private final ComalaI18nBean comalaI18nBean;

    public AbstractTableManager(BandanaManager bandanaManager, TransactionTemplate transactionTemplate, PluginAccessor pluginAccessor, ComalaPropertiesSetManager contentPropertyManager, SearchManager searchManager, AnyTypeDao anyTypeDao, PageManager pageManager, XhtmlContent xhtmlContent, ComalaI18nBean comalaI18nBean) {
        this.bandanaManager = bandanaManager;
        this.transactionTemplate = transactionTemplate;
        this.pluginAccessor = pluginAccessor;
        this.contentPropertyManager = contentPropertyManager;
        this.searchManager = searchManager;
        this.anyTypeDao = anyTypeDao;
        this.pageManager = pageManager;
        this.xhtmlContent = xhtmlContent;
        this.comalaI18nBean = comalaI18nBean;
    }

    public abstract String getMacroName();

    protected abstract Class getDescriptorClass();

    protected abstract String serializeMock(Table var1);

    protected abstract Table deserializeMock(String var1);

    @Deprecated
    protected abstract String getDefaultNewTableName();

    @Override
    public List<String> getNames(String spaceKey) {
        ConfluenceBandanaContext context = new ConfluenceBandanaContext(spaceKey);
        ArrayList<String> templates = new ArrayList<String>();
        for (String key : this.bandanaManager.getKeys((BandanaContext)context)) {
            String templateName = this.getTableName(key);
            if (templateName == null) continue;
            templates.add(templateName);
        }
        return templates;
    }

    @Override
    public List<String> getBundledNames() {
        ArrayList<String> names = new ArrayList<String>();
        List descriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(this.getDescriptorClass());
        for (TableModuleDescriptor descriptor : descriptors) {
            names.add(descriptor.getModule().getName());
        }
        return names;
    }

    @Override
    public List<TableManager.TableDescriptor<T>> getBundledDescriptors(boolean includeWizards) {
        ArrayList<TableManager.TableDescriptor<T>> tableDescriptors = new ArrayList<TableManager.TableDescriptor<T>>();
        List descriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(this.getDescriptorClass());
        for (TableModuleDescriptor descriptor : descriptors) {
            Object table = descriptor.getModule();
            TableManager.TableDescriptor<Object> tableDescriptor = new TableManager.TableDescriptor<Object>(table);
            tableDescriptor.setWizard(descriptor.getWizard());
            if (!includeWizards && StringUtils.isNotBlank((CharSequence)descriptor.getWizard())) continue;
            tableDescriptors.add(tableDescriptor);
        }
        return tableDescriptors;
    }

    @Override
    public List<TableManager.TableDescriptor<T>> getAllDescriptors(String spaceKey) {
        ISearch search;
        ArrayList<TableManager.TableDescriptor<T>> descriptors = new ArrayList<TableManager.TableDescriptor<T>>();
        if (spaceKey != null) {
            List<String> names = this.getNames(spaceKey);
            for (String name : names) {
                T table = this.get(spaceKey, name);
                if (table == null) continue;
                descriptors.add(new TableManager.TableDescriptor<T>(spaceKey, table));
            }
        }
        if ((search = this.makeSearch(null)) == null) {
            return descriptors;
        }
        HashSet<Integer> boardHashes = new HashSet<Integer>();
        try {
            SearchResults results = this.searchManager.search(search);
            for (SearchResult searchResult : results) {
                T properties;
                AbstractPage page = (AbstractPage)this.anyTypeDao.findByHandle(searchResult.getHandle());
                if (page == null || (properties = this.getFromPage(page)) == null || boardHashes.contains(properties.hashCode())) continue;
                descriptors.add(new TableManager.TableDescriptor<T>(page.getId(), properties));
                boardHashes.add(properties.hashCode());
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return descriptors;
    }

    @Override
    public boolean hasTables(String spaceKey) {
        if (spaceKey != null && this.getNames(spaceKey).size() > 0) {
            return true;
        }
        ISearch search = this.makeSearch(null);
        if (search == null) {
            return false;
        }
        try {
            SearchResults results = this.searchManager.search(search);
            return results.size() > 0;
        }
        catch (InvalidSearchException e) {
            log.error("", (Throwable)e);
            return false;
        }
    }

    @Override
    public List<TableManager.TableDescriptor<T>> getSpaceTables(String spaceKey) {
        if (!StringUtils.isNotBlank((CharSequence)spaceKey)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<TableManager.TableDescriptor<T>> descriptors = new ArrayList<TableManager.TableDescriptor<T>>();
        ISearch search = this.makeSearch(spaceKey);
        if (search == null) {
            return Collections.EMPTY_LIST;
        }
        try {
            SearchResults results = this.searchManager.search(search);
            for (SearchResult searchResult : results) {
                AbstractPage page = (AbstractPage)this.anyTypeDao.findByHandle(searchResult.getHandle());
                if (page == null) continue;
                T properties = this.getFromPage(page);
                descriptors.add(new TableManager.TableDescriptor<T>(page, properties));
            }
        }
        catch (InvalidSearchException e) {
            log.error("", (Throwable)e);
            return Collections.EMPTY_LIST;
        }
        return descriptors;
    }

    private ISearch makeSearch(String spaceKey) {
        HashSet<Object> mustQueries = new HashSet<Object>();
        if (spaceKey != null) {
            mustQueries.add(new InSpaceQuery(spaceKey));
        }
        mustQueries.add(new ContentTypeQuery(CONTENT_TYPES));
        mustQueries.add(new TextFieldQuery("adhoccanvas.board.flag", "true", BooleanOperator.AND));
        BooleanQuery query = new BooleanQuery(mustQueries, null, null);
        return new ComalaContentSearch((SearchQuery)query, (SearchSort)new ModifiedSort(SearchSort.Order.DESCENDING));
    }

    private T getTemplate(ConfluenceBandanaContext context, String key) {
        String templateName = this.getTableName(key);
        if (templateName == null) {
            return null;
        }
        String body = (String)this.bandanaManager.getValue((BandanaContext)context, key);
        if (body == null) {
            return null;
        }
        return this.deserialize(body);
    }

    @Override
    public void save(final String spaceKey, T table) {
        this.transactionTemplate.execute(new TransactionCallback(){
            final /* synthetic */ Table val$table;
            {
                this.val$table = table;
            }

            public Object doInTransaction() {
                ConfluenceBandanaContext context = new ConfluenceBandanaContext(spaceKey);
                String key = AbstractTableManager.this.makeTableKey(this.val$table.getName());
                String serialized = AbstractTableManager.this.serialize(this.val$table);
                AbstractTableManager.this.bandanaManager.setValue((BandanaContext)context, key, (Object)serialized);
                return null;
            }
        });
    }

    @Override
    public T parseJson(String tableMarkup) {
        try {
            return this.deserializeJson(tableMarkup);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.error("error parsing " + tableMarkup);
            }
            return null;
        }
    }

    @Override
    public String getNewTableName(ConfluenceEntityObject ceo) {
        int i = 1;
        Object suffix = "";
        String newName = this.getDefaultNewTableName();
        if (ceo instanceof ContentEntityObject) {
            while (((ContentEntityObject)ceo).getAttachmentNamed(this.makeAttachmentName(newName + (String)suffix)) != null) {
                suffix = " " + ++i;
            }
        }
        return newName + (String)suffix;
    }

    private String makeAttachmentName(String tableName) {
        return tableName.trim() + ".xml";
    }

    @Override
    public T get(String spaceKey, String tableName) {
        return this.getTemplate(new ConfluenceBandanaContext(spaceKey), this.makeTableKey(tableName));
    }

    @Override
    public T get(String tableName) {
        Class descriptorClass;
        if (tableName != null && (descriptorClass = this.getDescriptorClass()) != null) {
            List descriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(this.getDescriptorClass());
            for (TableModuleDescriptor descriptor : descriptors) {
                if (!tableName.equals(descriptor.getModule().getName()) && !tableName.equals(descriptor.getAlias())) continue;
                return (T)descriptor.getModule();
            }
        }
        return null;
    }

    @Override
    public T getBundled(long id) {
        if (this.getDescriptorClass() == null) {
            return null;
        }
        List descriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(this.getDescriptorClass());
        for (TableModuleDescriptor descriptor : descriptors) {
            if ((long)descriptor.getModule().getName().hashCode() != id) continue;
            return (T)descriptor.getModule();
        }
        return null;
    }

    @Override
    public T getFromPage(long id) {
        Page page = this.pageManager.getPage(id);
        if (page == null) {
            return null;
        }
        return this.getFromPage((AbstractPage)page);
    }

    @Override
    public T getFromPage(AbstractPage page) {
        ArrayList tables;
        block4: {
            String bodyAsString = page.getBodyAsString();
            if (!bodyAsString.contains(this.getMacroName())) {
                return null;
            }
            DefaultConversionContext context = new DefaultConversionContext((RenderContext)page.toPageContext());
            tables = new ArrayList();
            try {
                this.xhtmlContent.handleMacroDefinitions(bodyAsString, (ConversionContext)context, new MacroDefinitionHandler(){

                    public void handle(MacroDefinition macroDefinition) {
                        if (tables.size() > 0) {
                            return;
                        }
                        if (macroDefinition.getName().equals(AbstractTableManager.this.getMacroName())) {
                            tables.add(AbstractTableManager.this.parseJson(macroDefinition.getBody().getBody()));
                        }
                    }
                });
            }
            catch (Exception ignored) {
                if (!log.isDebugEnabled()) break block4;
                log.error(ignored.getMessage(), (Throwable)ignored);
            }
        }
        if (tables.size() == 0) {
            return null;
        }
        return (T)((Table)tables.get(0));
    }

    @Override
    public void delete(String spaceKey, String tableName) {
        this.transactionTemplate.execute(() -> {
            this.bandanaManager.removeValue((BandanaContext)new ConfluenceBandanaContext(spaceKey), this.makeTableKey(tableName));
            return null;
        });
    }

    @Override
    public String makeCopyName(String spaceKey, String name) {
        ConfluenceBandanaContext context = new ConfluenceBandanaContext(spaceKey);
        String copyName = this.comalaI18nBean.getText("adhoclists.boards.space.copy-of", new String[]{name});
        int i = 2;
        while (this.bandanaManager.getValue((BandanaContext)context, this.makeTableKey(copyName)) != null) {
            copyName = this.comalaI18nBean.getText("adhoclists.boards.space.n-copy-of", new String[]{Integer.toString(i), name});
            ++i;
        }
        return copyName;
    }

    @Override
    public boolean isTableRendered(ContentEntityObject ceo, String tableId) {
        String isCardsRendered = this.contentPropertyManager.getStringProperty(ceo, PROPERTY_KEY + tableId + ":cardsRendered");
        return StringUtils.isNotBlank((CharSequence)isCardsRendered) && "true".equalsIgnoreCase(isCardsRendered);
    }

    @Override
    public void setTableRendered(ContentEntityObject ceo, String tableId) {
        this.contentPropertyManager.setStringProperty(ceo, PROPERTY_KEY + tableId + ":cardsRendered", "true");
    }

    private String getTableName(String key) {
        if (key == null || !key.startsWith(this.getBandanaKey()) || key.length() <= this.getBandanaKey().length() - 1) {
            return null;
        }
        return key.substring(this.getBandanaKey().length() + 1);
    }

    private String makeTableKey(String name) {
        return this.getBandanaKey() + "." + name;
    }
}

