/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.rest.column;

import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.labels.ParsedLabelName;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.User;
import com.comalatech.confluence.adhoclists.AdhocListsException;
import com.comalatech.confluence.adhoclists.boards.BoardValidator;
import com.comalatech.confluence.adhoclists.condition.RestCondition;
import com.comalatech.confluence.adhoclists.exceptions.InvalidLabelException;
import com.comalatech.confluence.adhoclists.filter.FilterManager;
import com.comalatech.confluence.adhoclists.rest.AbstractChecklistResources;
import com.comalatech.confluence.adhoclists.rest.AbstractRestResources;
import com.comalatech.confluence.adhoclists.rest.PermissionRequired;
import com.comalatech.confluence.adhoclists.storage.serializer.ChecklistSerializer;
import com.comalatech.confluence.adhoclists.templates.AdhocTemplateManager;
import com.comalatech.confluence.adhoclists.utils.AdhocListsUtils;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Path(value="/lists/label")
public class LabelResources
extends AbstractChecklistResources {
    @Autowired
    public LabelResources(@ComponentImport PageManager pageManager, @ComponentImport SpaceManager spaceManager, @ComponentImport PermissionManager permissionManager, @ComponentImport LabelManager labelManager, FilterManager filterManager, @ComponentImport @Qualifier(value="contentEntityManager") ContentEntityManager contentEntityManager, AdhocTemplateManager adhocTemplateManager, @ComponentImport PageTemplateManager pageTemplateManager, @ComponentImport I18nResolver i18nResolver, RestCondition restCondition, BoardValidator boardValidator, @Qualifier(value="checklistJsonSerializer") ChecklistSerializer checklistSerializer, @ComponentImport VelocityHelperService velocityHelperService) {
        super(pageManager, spaceManager, permissionManager, labelManager, filterManager, contentEntityManager, adhocTemplateManager, pageTemplateManager, i18nResolver, restCondition, boardValidator, checklistSerializer, velocityHelperService);
    }

    private Label makeLabel(String labelName) throws AdhocListsException {
        if (labelName == null) {
            throw new AdhocListsException("Not label name set");
        }
        ParsedLabelName parsedLabel = LabelParser.parse((String)labelName, (User)AuthenticatedUserThreadLocal.get());
        if (parsedLabel == null) {
            throw new InvalidLabelException("Invalid label name " + labelName, labelName);
        }
        return parsedLabel.toLabel();
    }

    @PermissionRequired(permissionTypes={PermissionRequired.Type.VIEW, PermissionRequired.Type.EDIT})
    @POST
    @Consumes(value={"application/json"})
    @Path(value="/{pageid}/add")
    public Response addLabel(@PathParam(value="pageid") long pageId, final @QueryParam(value="label") String labelName) {
        return new AbstractRestResources.PageRestCommand(){

            @Override
            protected Response doInCommand(AbstractPage page) throws AdhocListsException {
                Label addLabel;
                List existingLabels = page.getLabels();
                if (!existingLabels.contains(addLabel = LabelResources.this.makeLabel(labelName))) {
                    LabelResources.this.labelManager.addLabel((Labelable)page, LabelResources.this.makeLabel(labelName));
                }
                return Response.ok().build();
            }
        }.execute(pageId);
    }

    @PermissionRequired(permissionTypes={PermissionRequired.Type.VIEW, PermissionRequired.Type.EDIT})
    @POST
    @Consumes(value={"application/json"})
    @Path(value="/{pageid}/remove")
    public Response removeLabel(@PathParam(value="pageid") long pageId, final @QueryParam(value="label") String labelName) {
        return new AbstractRestResources.PageRestCommand(){

            @Override
            protected Response doInCommand(AbstractPage page) throws AdhocListsException {
                LabelResources.this.labelManager.removeLabel((Labelable)page, LabelResources.this.makeLabel(labelName));
                return Response.ok().build();
            }
        }.execute(pageId);
    }

    @PermissionRequired(permissionTypes={PermissionRequired.Type.VIEW, PermissionRequired.Type.EDIT})
    @POST
    @Consumes(value={"application/json"})
    @Path(value="/{pageid}/toggle")
    public Response toggle(@PathParam(value="pageid") long pageId, final @QueryParam(value="label") String labelName, final @QueryParam(value="labels") String otherLabels) {
        return new AbstractRestResources.PageRestCommand(){

            @Override
            protected Response doInCommand(AbstractPage page) throws AdhocListsException {
                String[] labelsToRemove;
                List existingLabels = page.getLabels();
                for (String labelName2 : labelsToRemove = AdhocListsUtils.splitAndTrim(otherLabels)) {
                    Label labelToRemove = LabelResources.this.makeLabel(labelName2);
                    if (!existingLabels.contains(labelToRemove)) continue;
                    int index = existingLabels.indexOf(labelToRemove);
                    LabelResources.this.labelManager.removeLabel((Labelable)page, (Label)existingLabels.get(index));
                }
                Label label = LabelResources.this.makeLabel(labelName);
                existingLabels = page.getLabels();
                if (StringUtils.isNotBlank((CharSequence)labelName) && !existingLabels.contains(label)) {
                    LabelResources.this.labelManager.addLabel((Labelable)page, label);
                }
                return Response.ok().build();
            }
        }.execute(pageId);
    }
}

