/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.rest;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.ConversionContextOutputType;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.Renderer;
import com.atlassian.confluence.core.BodyContent;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.sal.api.message.I18nResolver;
import com.comalatech.confluence.adhoclists.AdhocListsException;
import com.comalatech.confluence.adhoclists.boards.BoardValidator;
import com.comalatech.confluence.adhoclists.boards.events.ListPageCreatedEvent;
import com.comalatech.confluence.adhoclists.condition.RestCondition;
import com.comalatech.confluence.adhoclists.filter.FilterManager;
import com.comalatech.confluence.adhoclists.lists.ChecklistCreator;
import com.comalatech.confluence.adhoclists.lists.ChecklistHandler;
import com.comalatech.confluence.adhoclists.lists.ChecklistRenderer;
import com.comalatech.confluence.adhoclists.lists.model.Checklist;
import com.comalatech.confluence.adhoclists.lists.model.ChecklistViewContext;
import com.comalatech.confluence.adhoclists.lists.model.Column;
import com.comalatech.confluence.adhoclists.lists.model.ListRows;
import com.comalatech.confluence.adhoclists.lists.model.PageValueType;
import com.comalatech.confluence.adhoclists.lists.types.PageColumn;
import com.comalatech.confluence.adhoclists.lists.types.Types;
import com.comalatech.confluence.adhoclists.model.Filter;
import com.comalatech.confluence.adhoclists.model.Styles;
import com.comalatech.confluence.adhoclists.module.GlobalConfigManager;
import com.comalatech.confluence.adhoclists.rest.AbstractChecklistResources;
import com.comalatech.confluence.adhoclists.rest.AbstractRestResources;
import com.comalatech.confluence.adhoclists.rest.AdhocListsRestException;
import com.comalatech.confluence.adhoclists.rest.PermissionRequired;
import com.comalatech.confluence.adhoclists.storage.AdhocListManager;
import com.comalatech.confluence.adhoclists.storage.serializer.ChecklistSerializer;
import com.comalatech.confluence.adhoclists.templates.AdhocTemplateManager;
import com.comalatech.confluence.adhoclists.templates.model.AdhocTemplate;
import com.comalatech.confluence.adhoclists.utils.AdhocListsUtils;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Path(value="/lists")
public class ChecklistResources
extends AbstractChecklistResources {
    private static final Logger log = LoggerFactory.getLogger(ChecklistResources.class);
    private final ChecklistRenderer checklistRenderer;
    private final AdhocListManager adhocListManager;
    private final ChecklistCreator checklistCreator;
    private final ChecklistHandler checklistHandler;
    private final Renderer viewRenderer;
    private final GlobalConfigManager globalConfigManager;
    private final EventPublisher eventPublisher;
    private final ComalaI18nBean comalaI18nBean;

    @Autowired
    public ChecklistResources(@ComponentImport PageManager pageManager, @ComponentImport SpaceManager spaceManager, @ComponentImport PermissionManager permissionManager, @ComponentImport LabelManager labelManager, FilterManager filterManager, @ComponentImport @Qualifier(value="contentEntityManager") ContentEntityManager contentEntityManager, AdhocTemplateManager adhocTemplateManager, @ComponentImport PageTemplateManager pageTemplateManager, @ComponentImport I18nResolver i18nResolver, RestCondition restCondition, BoardValidator boardValidator, @Qualifier(value="checklistJsonSerializer") ChecklistSerializer checklistSerializer, ChecklistRenderer checklistRenderer, AdhocListManager adhocListManager, ChecklistCreator checklistCreator, ChecklistHandler checklistHandler, @ComponentImport Renderer viewRenderer, GlobalConfigManager globalConfigManager, @ComponentImport EventPublisher eventPublisher, ComalaI18nBean comalaI18nBean, @ComponentImport VelocityHelperService velocityHelperService) {
        super(pageManager, spaceManager, permissionManager, labelManager, filterManager, contentEntityManager, adhocTemplateManager, pageTemplateManager, i18nResolver, restCondition, boardValidator, checklistSerializer, velocityHelperService);
        this.checklistRenderer = checklistRenderer;
        this.adhocListManager = adhocListManager;
        this.checklistCreator = checklistCreator;
        this.checklistHandler = checklistHandler;
        this.viewRenderer = viewRenderer;
        this.globalConfigManager = globalConfigManager;
        this.eventPublisher = eventPublisher;
        this.comalaI18nBean = comalaI18nBean;
    }

    @GET
    @Path(value="/{spaceKey}/select")
    @Produces(value={"text/plain"})
    @PermissionRequired(permissionTypes={PermissionRequired.Type.VIEW, PermissionRequired.Type.CREATEPAGE, PermissionRequired.Type.SHOWLIST})
    public Response select(final @PathParam(value="spaceKey") String spaceKey, final @QueryParam(value="name") String name, final @QueryParam(value="parent") String parent, final @QueryParam(value="filterspacekey") String filterSpaceKey, final @QueryParam(value="labels") String labels, final @QueryParam(value="depth") String depth, final @QueryParam(value="allSpaces") boolean allSpaces) {
        return new AbstractRestResources.SpaceRestCommand(){

            @Override
            protected Response doInCommand(Space space) throws AdhocListsException {
                HashMap<String, Object> context = new HashMap<String, Object>();
                context.put("spaceLists", ChecklistResources.this.adhocListManager.getNames(space.getKey()));
                context.put("pageLists", Collections.unmodifiableList(ChecklistResources.this.adhocListManager.getBundledNames()));
                context.put("name", name);
                context.put("spaceKey", StringUtils.isNotBlank((CharSequence)filterSpaceKey) ? filterSpaceKey : spaceKey);
                context.put("pageFilter", true);
                context.put("allSpaces", allSpaces);
                Filter filter = new Filter();
                filter.setLabels(ChecklistResources.this.getLabels(labels));
                filter.setParent(parent);
                filter.setSpaceKey(filterSpaceKey);
                filter.setAllSpaces(allSpaces);
                if (StringUtils.isNotBlank((CharSequence)depth)) {
                    try {
                        filter.setDepth(Integer.parseInt(depth));
                    }
                    catch (NumberFormatException e) {
                        log.error("depth incorrect : ", (Throwable)e);
                    }
                }
                context.put("filter", filter);
                return Response.ok((Object)ChecklistResources.this.renderTemplateHtml("/templates/adhoclists/vm/checklists/rte/selectlist.vm", context)).build();
            }
        }.execute(spaceKey);
    }

    @GET
    @PermissionRequired(permissionTypes={PermissionRequired.Type.VIEW, PermissionRequired.Type.SHOWLIST})
    @Path(value="/{spaceKey}/namedpreview")
    @Produces(value={"text/plain"})
    public Response previewTemplate(final @PathParam(value="spaceKey") String spaceKey, final @QueryParam(value="name") String name, final @QueryParam(value="space") boolean spaceList, final @QueryParam(value="popularLabels") boolean popularLabels) {
        return new AbstractRestResources.SpaceRestCommand(){

            @Override
            protected Response doInCommand(Space space) throws AdhocListsException {
                Checklist checklist = spaceList ? (Checklist)ChecklistResources.this.adhocListManager.get(spaceKey, name) : (popularLabels ? ChecklistResources.this.checklistCreator.createPopularLabelsChecklist(spaceKey) : (Checklist)ChecklistResources.this.adhocListManager.get(name));
                if (checklist == null) {
                    throw new AdhocListsException("Invalid list name " + name);
                }
                ChecklistViewContext viewContext = new ChecklistViewContext(spaceKey, 0, 5);
                viewContext.setPreview(true);
                return Response.ok((Object)ChecklistResources.this.checklistRenderer.renderChecklist(viewContext, checklist, new Filter())).build();
            }
        }.execute(spaceKey);
    }

    @GET
    @Path(value="/{contentId}/get")
    @Produces(value={"text/plain"})
    @PermissionRequired(permissionTypes={PermissionRequired.Type.VIEW, PermissionRequired.Type.EDIT, PermissionRequired.Type.SHOWLIST})
    public Response get(@PathParam(value="contentId") long contentId, final @QueryParam(value="name") String name, @QueryParam(value="space") String deprecatedParamSpaceList, final @QueryParam(value="popularLabels") boolean popularLabels, final @QueryParam(value="empty") boolean empty, final @QueryParam(value="listMarkup") String listMarkup, final @QueryParam(value="macroId") String macroId) {
        return new AbstractRestResources.ContentRestCommand(){

            @Override
            protected Response doInCommand(ConfluenceEntityObject ceo) throws AdhocListsException {
                Checklist checklist;
                String spaceKey = this.getSpaceKey(ceo);
                if (empty) {
                    checklist = new Checklist();
                    checklist.addColumn(new PageColumn(PageValueType.Type.VIEWLINK));
                    checklist.setName(ChecklistResources.this.adhocListManager.getNewTableName(ceo));
                } else if (StringUtils.isNotBlank((CharSequence)listMarkup)) {
                    checklist = (Checklist)ChecklistResources.this.checklistSerializer.deserialize(listMarkup, macroId);
                    if (checklist == null) {
                        throw new AdhocListsException("Invalid list markup");
                    }
                } else if (popularLabels) {
                    checklist = ChecklistResources.this.checklistCreator.createPopularLabelsChecklist(this.getSpaceKey(ceo));
                } else {
                    checklist = (Checklist)ChecklistResources.this.adhocListManager.get(spaceKey, name);
                    if (checklist == null) {
                        checklist = (Checklist)ChecklistResources.this.adhocListManager.get(name);
                    }
                }
                if (checklist == null) {
                    throw new AdhocListsException("Invalid checklist " + name);
                }
                return Response.ok((Object)ChecklistResources.this.serializeTable(checklist)).build();
            }
        }.execute(contentId);
    }

    @POST
    @Path(value="/{contentId}/edit")
    @PermissionRequired(permissionTypes={PermissionRequired.Type.VIEW, PermissionRequired.Type.EDIT, PermissionRequired.Type.SHOWLIST})
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"text/plain"})
    public Response editChecklist(@PathParam(value="contentId") long contentId, final @QueryParam(value="parent") String parent, final @QueryParam(value="filterspacekey") String filterSpaceKey, final @QueryParam(value="labels") String labels, final @QueryParam(value="depth") String depth, final String jsonTable) {
        return new AbstractRestResources.ContentRestCommand(){

            @Override
            protected Response doInCommand(ConfluenceEntityObject ceo) throws AdhocListsException {
                Checklist checklist = (Checklist)ChecklistResources.this.deserializeTable(jsonTable);
                if (checklist == null) {
                    throw new AdhocListsException("error parsing checklist " + jsonTable);
                }
                HashMap<String, Object> context = new HashMap<String, Object>();
                ChecklistViewContext viewContext = new ChecklistViewContext(this.getSpaceKey(ceo), 0, 5);
                context.put("renderedChecklistHtml", ChecklistResources.this.checklistRenderer.renderChecklistDesigner(viewContext, checklist));
                checklist.setDescription(null);
                context.put("checklistMarkup", ChecklistResources.this.checklistSerializer.serialize(checklist));
                context.put("checklist", checklist);
                Filter filter = new Filter();
                filter.setParent(parent);
                filter.setSpaceKey(filterSpaceKey);
                filter.setLabels(ChecklistResources.this.getLabels(labels));
                if (StringUtils.isNotBlank((CharSequence)depth)) {
                    try {
                        filter.setDepth(Integer.parseInt(depth));
                    }
                    catch (NumberFormatException e) {
                        log.error("depth incorrect : ", (Throwable)e);
                    }
                }
                int defaultMaxRows = ChecklistResources.this.globalConfigManager.loadGlobalConfig().getMaxListRows();
                context.put("spaceKey", StringUtils.isNotBlank((CharSequence)filterSpaceKey) ? filterSpaceKey : this.getSpaceKey(ceo));
                context.put("filter", filter);
                context.put("styles", Styles.getInstance());
                context.put("pageFilter", true);
                context.put("globalTemplates", ChecklistResources.this.adhocTemplateManager.getPageTemplateNames(null));
                context.put("spaceTemplates", ChecklistResources.this.adhocTemplateManager.getPageTemplateNames(viewContext.getSpaceKey()));
                context.put("defaultMaxRows", defaultMaxRows);
                String response = ChecklistResources.this.renderTemplateHtml("/templates/adhoclists/vm/checklists/rte/editchecklist.vm", context);
                return Response.ok((Object)response).build();
            }
        }.execute(contentId);
    }

    @POST
    @Path(value="/rows")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json", "application/xml"})
    @PermissionRequired(permissionTypes={PermissionRequired.Type.VIEW})
    public Response getRowsHtml(final @QueryParam(value="spaceKey") String spaceKey, final @QueryParam(value="start") int start, final @QueryParam(value="count") int count, final @QueryParam(value="labels") String labels, final @QueryParam(value="parent") long filterParentId, final @QueryParam(value="depth") String depth, @QueryParam(value="macroId") String macroId, String jsonChecklist) {
        return new AbstractRestResources.TableRestCommand(){

            protected Response doInCommand(Checklist checklist) throws AdhocListsException {
                ChecklistViewContext viewContext = new ChecklistViewContext(spaceKey, start, count);
                Filter filter = new Filter(ChecklistResources.this.getLabels(labels));
                filter.setSpaceKey(spaceKey);
                if (StringUtils.isNotBlank((CharSequence)depth)) {
                    try {
                        filter.setDepth(Integer.parseInt(depth));
                    }
                    catch (NumberFormatException e) {
                        log.error("depth incorrect : ", (Throwable)e);
                    }
                }
                Page parent = filterParentId > 0L ? (Page)this.getPage(filterParentId) : null;
                ListRows renderedRows = ChecklistResources.this.checklistRenderer.renderPages(viewContext, checklist, filter, parent);
                return Response.ok((Object)renderedRows).build();
            }
        }.execute(jsonChecklist, macroId);
    }

    @POST
    @Path(value="/{spaceKey}/addpage")
    @Produces(value={"text/plain"})
    @Consumes(value={"application/json"})
    @PermissionRequired(permissionTypes={PermissionRequired.Type.VIEW, PermissionRequired.Type.CREATEPAGE})
    public Response addPageHtml(final @PathParam(value="spaceKey") String spaceKey, final @QueryParam(value="pageId") long parentId, final @QueryParam(value="filterLabels") String filterLabels, final @QueryParam(value="title") String title, final @QueryParam(value="macroId") String macroId, final Map<String, String> formParam) {
        return new AbstractRestResources.SpaceRestCommand(){

            @Override
            protected Response doInCommand(Space space) throws AdhocListsException {
                Page page;
                Object body;
                Page parent;
                Page page2 = parent = parentId > 0L ? (Page)this.getPage(parentId) : null;
                if (ChecklistResources.this.pageManager.getPage(space.getKey(), title) != null) {
                    throw new AdhocListsRestException(400, ChecklistResources.this.comalaI18nBean.getText("adhoclists.checklists.error.duplicate-page", new String[]{title}));
                }
                String jsonChecklist = (String)formParam.get("checklist");
                String excerpt = (String)formParam.get("excerpt");
                Checklist checklist = (Checklist)ChecklistResources.this.deserializeTable(jsonChecklist, macroId);
                HashSet<Label> labels = new HashSet<Label>();
                for (String filterLabel : ChecklistResources.this.getLabels(filterLabels)) {
                    labels.add(new Label(filterLabel));
                }
                AdhocTemplate template = ChecklistResources.this.adhocTemplateManager.getTemplate(spaceKey, checklist.getTemplateName());
                if (template != null) {
                    AdhocTemplate.TemplateVariable excerptVariable = template.getVariable("excerpt");
                    if (excerptVariable != null) {
                        excerptVariable.setValue(AdhocListsUtils.clean(excerpt));
                    }
                    body = ChecklistResources.this.adhocTemplateManager.mergeTemplateVariables(template, space.getKey());
                    labels.addAll(template.getPageTemplate().getLabels());
                    BodyContent bodyContent = new BodyContent();
                    bodyContent.setBody((String)body);
                    page = ChecklistResources.this.checklistHandler.createPage(space, title, bodyContent, parent);
                } else {
                    body = StringUtils.isNotBlank((CharSequence)excerpt) ? "{excerpt}" + AdhocListsUtils.clean(excerpt) + "{excerpt}\n" : null;
                    page = ChecklistResources.this.checklistHandler.createPageWikiBody(space, title, (String)body, parent);
                }
                Page thePage = ChecklistResources.this.pageManager.getPage(page.getId());
                for (Label label : labels) {
                    if (thePage == null || thePage.getLabels().contains(label)) continue;
                    Label persistedLabel = ChecklistResources.this.labelManager.getLabel(label);
                    ChecklistResources.this.labelManager.addLabel((Labelable)thePage, persistedLabel != null ? persistedLabel : label);
                }
                ChecklistResources.this.eventPublisher.publish((Object)new ListPageCreatedEvent());
                ChecklistViewContext viewContext = new ChecklistViewContext(spaceKey, 0, 1);
                String renderedRows = ChecklistResources.this.checklistRenderer.renderPage(viewContext, checklist, (AbstractPage)page);
                return Response.ok((Object)renderedRows).build();
            }
        }.execute(spaceKey);
    }

    @POST
    @PermissionRequired(permissionTypes={PermissionRequired.Type.VIEW})
    @Path(value="/form")
    @Produces(value={"text/plain"})
    @Consumes(value={"application/json"})
    public Response getColumnForm(@QueryParam(value="type") String type, final @QueryParam(value="spaceKey") String spaceKey, String jsonColumn) {
        return new AbstractChecklistResources.ColumnRestCommand<Column>(){

            @Override
            protected Response doInCommand(Column column) throws AdhocListsException {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("column", column);
                if (StringUtils.isNotBlank((CharSequence)spaceKey)) {
                    parameters.put("space", this.getSpace(spaceKey));
                }
                return ChecklistResources.this.renderTemplate("/templates/adhoclists/vm/checklists/columns/form.vm", parameters);
            }
        }.execute(jsonColumn, type);
    }

    @GET
    @Path(value="/form/new")
    @Produces(value={"text/plain"})
    public Response getNewColumnFom() {
        return new AbstractRestResources.AbstractRestCommand(){

            @Override
            protected Response doInCommand() throws AdhocListsException {
                return ChecklistResources.this.renderTemplate("/templates/adhoclists/vm/checklists/columns/newcolumnform.vm", "types", Types.getTypeOptions());
            }
        }.execute();
    }

    @POST
    @Path(value="/{spaceKey}/save")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @PermissionRequired(permissionTypes={PermissionRequired.Type.VIEW, PermissionRequired.Type.EDIT, PermissionRequired.Type.SHOWLIST})
    public Response saveChecklist(@PathParam(value="spaceKey") String spaceKey, final @QueryParam(value="labels") String labels, final @QueryParam(value="parent") String parent, final @QueryParam(value="depth") String depth, final Checklist checklist) {
        return new AbstractRestResources.SpaceRestCommand(){

            @Override
            protected Response doInCommand(Space space) throws AdhocListsException {
                ChecklistResources.this.adhocListManager.save(space.getKey(), checklist);
                Filter filter = new Filter(ChecklistResources.this.getLabels(labels));
                filter.setParent(parent);
                if (StringUtils.isNotBlank((CharSequence)depth)) {
                    try {
                        filter.setDepth(Integer.parseInt(depth));
                    }
                    catch (NumberFormatException e) {
                        log.error("depth incorrect : ", (Throwable)e);
                    }
                }
                ChecklistResources.this.filterManager.save(space.getKey(), checklist, filter);
                return Response.ok().build();
            }
        }.execute(spaceKey);
    }

    @GET
    @Path(value="/{pageId}/metadata")
    @PermissionRequired(permissionTypes={PermissionRequired.Type.VIEW})
    @Produces(value={"text/plain"})
    public Response getPageMetadata(@PathParam(value="pageId") long pageId) {
        return new AbstractRestResources.PageRestCommand(){

            @Override
            protected Response doInCommand(AbstractPage page) throws AdhocListsException {
                return ChecklistResources.this.renderTemplate("/templates/adhoclists/vm/pagepopup.vm", "page", page);
            }
        }.execute(pageId);
    }

    @GET
    @Path(value="/{pageId}/render")
    @PermissionRequired(permissionTypes={PermissionRequired.Type.VIEW})
    @Produces(value={"text/plain"})
    public Response renderPage(@PathParam(value="pageId") long pageId) {
        return new AbstractRestResources.PageRestCommand(){

            @Override
            protected Response doInCommand(AbstractPage page) {
                PageContext renderContext = page.toPageContext();
                renderContext.setOutputType(ConversionContextOutputType.PREVIEW.name());
                DefaultConversionContext context = new DefaultConversionContext((RenderContext)renderContext);
                return Response.ok((Object)ChecklistResources.this.viewRenderer.render((ContentEntityObject)page, (ConversionContext)context)).build();
            }
        }.execute(pageId);
    }
}

