/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.metadata;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.adhoclists.content.ComalaPropertiesSetManager;
import com.comalatech.confluence.adhoclists.metadata.MetadataAccessor;
import com.comalatech.confluence.adhoclists.utils.PluginContainerManager;

public class MetadataMetadataAccessor
implements MetadataAccessor {
    public static final String METADATA_KEY_PREFIX = "metadata.";
    public static final String METADATA_KEYS = "metadatakeys";
    public static final String METADATA_KEYS_SEPARATOR = "|";
    private static final MetadataMetadataAccessor INSTANCE = new MetadataMetadataAccessor();
    private ComalaPropertiesSetManager comalaPropertiesSetManager = PluginContainerManager.getComponent(ComalaPropertiesSetManager.class);

    private MetadataMetadataAccessor() {
    }

    public static MetadataMetadataAccessor getInstance() {
        return INSTANCE;
    }

    @Override
    public String getValue(AbstractPage page, String valueName) {
        String key = METADATA_KEY_PREFIX + valueName.trim();
        String value = this.comalaPropertiesSetManager.getTextProperty((ContentEntityObject)page.getLatestVersion(), key);
        if (value != null) {
            return value;
        }
        return "";
    }

    @Override
    public void setValue(AbstractPage page, String key, String value) {
        key = key.trim();
        this.comalaPropertiesSetManager.setTextProperty((ContentEntityObject)page, METADATA_KEY_PREFIX + key, value);
        this.addMetadataKey(page, key);
    }

    private void addMetadataKey(AbstractPage page, String key) {
        String keysList = this.comalaPropertiesSetManager.getTextProperty((ContentEntityObject)page, METADATA_KEYS);
        StringBuffer newList = new StringBuffer();
        String separator = "";
        if (keysList != null) {
            String[] keys;
            for (String key1 : keys = keysList.split("\\|")) {
                String existingKey = key1.trim();
                if (existingKey.equals(key)) {
                    return;
                }
                newList.append(separator).append(existingKey);
                separator = METADATA_KEYS_SEPARATOR;
            }
        }
        newList.append(separator).append(key);
        this.comalaPropertiesSetManager.setTextProperty((ContentEntityObject)page, METADATA_KEYS, newList.toString());
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }
}

