/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.lists.types;

import com.comalatech.confluence.adhoclists.lists.model.Checklist;
import com.comalatech.confluence.adhoclists.lists.model.ChecklistColumn;
import com.comalatech.confluence.adhoclists.lists.model.Column;
import com.comalatech.confluence.adhoclists.lists.model.Option;
import com.comalatech.confluence.adhoclists.lists.model.PageValueType;
import com.comalatech.confluence.adhoclists.lists.types.InputColumn;
import com.comalatech.confluence.adhoclists.lists.types.LabelColumn;
import com.comalatech.confluence.adhoclists.lists.types.MetadataColumn;
import com.comalatech.confluence.adhoclists.lists.types.PageColumn;
import com.comalatech.confluence.adhoclists.lists.types.SelectLabelColumn;
import com.comalatech.confluence.adhoclists.lists.types.SelectUserColumn;
import com.comalatech.confluence.adhoclists.lists.types.SelectValueColumn;
import com.comalatech.confluence.adhoclists.lists.types.WikiColumn;
import com.comalatech.confluence.adhoclists.lists.types.WikiInputColumn;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Types {
    public static final Class[] ALL_TYPES = new Class[]{LabelColumn.class, SelectLabelColumn.class, PageColumn.class, SelectValueColumn.class, InputColumn.class, WikiInputColumn.class, MetadataColumn.class, SelectUserColumn.class, WikiColumn.class};
    public static final Class[] AUXCLASSES = new Class[]{Checklist.class, PageValueType.Type.class, Option.class};
    public static final Map<String, Class> TYPE_BY_KEY = new HashMap<String, Class>();

    public static Class getColumnType(String key) {
        return TYPE_BY_KEY.get(key);
    }

    public static List<TypeOption> getTypeOptions() {
        ArrayList<TypeOption> types = new ArrayList<TypeOption>();
        for (Class type : ALL_TYPES) {
            ChecklistColumn checklistColumn = type.getAnnotation(ChecklistColumn.class);
            if (checklistColumn == null || checklistColumn.typeNameKey() == null) continue;
            types.add(new TypeOption(Column.getTypeStatic(type), ComalaI18nBean.getComalaI18nBean().getText(checklistColumn.typeNameKey()), ComalaI18nBean.getComalaI18nBean().getText(checklistColumn.typeHintKey()), ComalaI18nBean.getComalaI18nBean().getText(checklistColumn.columnGroup().getKey())));
        }
        return types;
    }

    static {
        for (Class type : ALL_TYPES) {
            TYPE_BY_KEY.put(Column.getTypeStatic(type), type);
        }
    }

    public static class TypeOption {
        private final String key;
        private final String typeTitle;
        private final String typeHint;
        private final String groupTitle;

        public TypeOption(String key, String typeTitle, String typeHint, String groupTitle) {
            this.key = key;
            this.typeTitle = typeTitle;
            this.groupTitle = groupTitle;
            this.typeHint = typeHint;
        }

        public String getTypeHint() {
            return this.typeHint;
        }

        public String getGroupTitle() {
            return this.groupTitle;
        }

        public String getKey() {
            return this.key;
        }

        public String getTypeTitle() {
            return this.typeTitle;
        }
    }
}

