/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.lists.model;

import com.comalatech.confluence.adhoclists.lists.model.ValueType;
import com.comalatech.confluence.i18n.ComalaI18nBean;

public class PageValueType
implements ValueType {
    private final Type type;

    public PageValueType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public Type[] getTypes() {
        return Type.values();
    }

    public static enum Type {
        VIEWLINK("heading.page.title", "pageview", "adhoclists.checklists.designer.column.page.viewlink"),
        CREATOR("heading.creator", "pagecreator", "adhoclists.checklists.designer.column.page.creator"),
        CREATIONDATE("heading.creation.date", "pagecreated", "adhoclists.checklists.designer.column.page.created"),
        MODIFIER("heading.modifier", "pagemodifier", "adhoclists.checklists.designer.column.page.modifier"),
        MODIFIED_DATE("heading.mod.date", "pagemodified", "adhoclists.checklists.designer.column.page.modified"),
        EXCERPT("heading.page.excerpt", "pageexcerpt", "adhoclists.checklists.designer.column.page.excerpt"),
        INCLUDE("heading.page.include", "pageinclude", "adhoclists.checklists.designer.column.page.include"),
        EDITLINK("heading.page.edit", "pageedit", "adhoclists.checklists.designer.column.page.editlink");

        final String header;
        final String key;
        final String captionKey;

        public String getHeader() {
            return ComalaI18nBean.getComalaI18nBean().getText(this.header);
        }

        private Type(String header, String key, String captionKey) {
            this.header = header;
            this.key = key;
            this.captionKey = captionKey;
        }

        public String getKey() {
            return this.key;
        }

        public String getCaptionKey() {
            return this.captionKey;
        }
    }
}

