/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.lists;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.search.page.Pager;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ChecklistUserManager {
    public static final int MAX_USERS = 60;
    private final UserAccessor userAccessor;
    private final GroupManager groupManager;

    public ChecklistUserManager(@ComponentImport UserAccessor userAccessor, @ComponentImport GroupManager groupManager) {
        this.userAccessor = userAccessor;
        this.groupManager = groupManager;
    }

    public List<ConfluenceUser> getUsers(String groupName) throws Exception {
        Pager pager;
        ArrayList<ConfluenceUser> users = new ArrayList<ConfluenceUser>();
        if (groupName == null) {
            pager = this.userAccessor.getUserNames();
        } else {
            Group group = this.groupManager.getGroup(groupName);
            if (groupName.equalsIgnoreCase("all")) {
                pager = group == null ? this.userAccessor.getUserNames() : this.groupManager.getMemberNames(group);
            } else if (group != null) {
                pager = this.groupManager.getMemberNames(group);
            } else {
                throw new Exception("group " + groupName + " does not exist");
            }
            if (pager == null) {
                throw new Exception("could not retrieve users for group " + groupName + " because of issues in confluence handling externally managed groups. see CHK-15");
            }
        }
        while (pager.getCurrentPage().size() > 0) {
            if (users.size() > 60) {
                throw new Exception("users list for selection cannot be more than 60 try a more restrictive group");
            }
            for (String user : pager.getCurrentPage()) {
                users.add(this.userAccessor.getUserByName(user));
            }
            if (pager.onLastPage()) break;
            pager.nextPage();
        }
        return users;
    }
}

