/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.cards;

import com.atlassian.confluence.core.ContentEntityObject;
import com.comalatech.confluence.adhoclists.cards.CardAccessor;
import com.comalatech.confluence.adhoclists.cards.CardManager;
import com.comalatech.confluence.adhoclists.cards.model.Card;
import com.comalatech.confluence.adhoclists.cards.model.Cards;
import com.comalatech.confluence.adhoclists.cards.model.ResolvedCard;
import com.comalatech.confluence.boards.model.Board;
import com.comalatech.confluence.boards.model.Container;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultCardManager
implements CardManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultCardManager.class);
    private final CardAccessor cardAccessor;

    public DefaultCardManager(CardAccessor cardAccessor) {
        this.cardAccessor = cardAccessor;
    }

    @Override
    public Map<String, Cards> getAllExistingCards(ContentEntityObject ceo, Board board) {
        HashMap<String, Cards> existingCards = new HashMap<String, Cards>();
        if (board == null) {
            return existingCards;
        }
        for (Board.Row row : board.getRows()) {
            for (Board.Column column : row.getColumns()) {
                for (Container container : column.getContainers()) {
                    Cards pageCards = this.getCards(ceo, container.getKey());
                    if (pageCards.size() <= 0) continue;
                    existingCards.put(container.getKey(), pageCards);
                }
            }
        }
        return existingCards;
    }

    @Override
    public Map<String, List<ResolvedCard>> getAllPredefinedCards(ContentEntityObject ceo, Board board) {
        HashMap<String, List<ResolvedCard>> predefinedCards = new HashMap<String, List<ResolvedCard>>();
        if (board == null) {
            return predefinedCards;
        }
        for (Board.Row row : board.getRows()) {
            for (Board.Column column : row.getColumns()) {
                for (Container container : column.getContainers()) {
                    if (container.getCards() == null) continue;
                    for (String cardBody : container.getCards()) {
                        ArrayList<ResolvedCard> cards = predefinedCards.get(container.getKey()) == null ? new ArrayList<ResolvedCard>() : predefinedCards.get(container.getKey());
                        cards.add(new ResolvedCard(cardBody));
                        predefinedCards.put(container.getKey(), cards);
                    }
                }
            }
        }
        return predefinedCards;
    }

    @Override
    public Cards createCards(List<String> cardsBodies) {
        Cards cards = new Cards(new ArrayList<Card>());
        if (cardsBodies == null || cardsBodies.size() == 0) {
            return cards;
        }
        for (String cardBody : cardsBodies) {
            cards.add(new Card(null, cardBody));
        }
        return cards;
    }

    @Override
    public Cards getCards(ContentEntityObject ceo, String key) {
        List<Card> cards = this.cardAccessor.getCards(ceo, key);
        try {
            return new Cards(cards);
        }
        catch (IllegalArgumentException e) {
            log.error("Invalids cards " + cards);
            return new Cards(new ArrayList<Card>());
        }
    }

    @Override
    public void saveCards(ContentEntityObject ceo, String key, Cards cards) {
        this.cardAccessor.saveCards(ceo, key, cards.getForStorage());
    }

    @Override
    public void moveCard(ContentEntityObject ceo, Card card, String fromKey, String toKey, Card before) {
        if (ceo == null) {
            return;
        }
        log.debug("\n moving card " + card.toString());
        if (toKey != null) {
            if (toKey.equals(fromKey) || fromKey == null) {
                Cards cards = this.getCards(ceo, toKey);
                cards.moveBefore(before, card);
                this.saveIfDirty(ceo, toKey, cards);
            } else {
                Cards fromCards = this.getCards(ceo, fromKey);
                Cards toCards = this.getCards(ceo, toKey);
                fromCards.remove(card);
                toCards.moveBefore(before, card);
                this.saveIfDirty(ceo, fromKey, fromCards);
                this.saveIfDirty(ceo, toKey, toCards);
                log.debug("\n from cards \n " + fromCards.toString());
                log.debug("\n to cards \n " + toCards.toString());
            }
        } else {
            if (fromKey == null) {
                return;
            }
            Cards cards = this.getCards(ceo, fromKey);
            cards.remove(card);
            this.saveIfDirty(ceo, fromKey, cards);
        }
    }

    @Override
    public void addCard(ContentEntityObject ceo, Card card, String key) {
        if (ceo == null) {
            return;
        }
        Cards cards = this.getCards(ceo, key);
        cards.add(card);
        this.saveIfDirty(ceo, key, cards);
    }

    @Override
    public void updateCard(ContentEntityObject ceo, Card card, String key, String body) {
        if (ceo == null) {
            return;
        }
        if (card.getId() != null) {
            throw new IllegalArgumentException("Cannot set body to a reference card " + card);
        }
        Cards cards = this.getCards(ceo, key);
        Card existingCard = cards.get(card);
        if (existingCard == null) {
            throw new IllegalArgumentException("card " + card + " does not exist");
        }
        Card newCard = new Card();
        newCard.setBody(body);
        cards.replace(existingCard, newCard);
        this.saveIfDirty(ceo, key, cards);
    }

    @Override
    public void removeCards(ContentEntityObject ceo, String key) {
        this.cardAccessor.removeCards(ceo, key);
    }

    private void saveIfDirty(ContentEntityObject ceo, String key, Cards cards) {
        if (cards.isDirty()) {
            this.saveCards(ceo, key, cards);
        }
    }
}

