/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.boards.macro;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.user.User;
import com.comalatech.confluence.adhoclists.boards.BoardCreator;
import com.comalatech.confluence.adhoclists.boards.BoardRenderer;
import com.comalatech.confluence.adhoclists.cards.CardManager;
import com.comalatech.confluence.adhoclists.condition.ConditionalMacro;
import com.comalatech.confluence.adhoclists.condition.RestCondition;
import com.comalatech.confluence.adhoclists.filter.FilterManager;
import com.comalatech.confluence.adhoclists.license.AdhocLicenseManager;
import com.comalatech.confluence.adhoclists.lists.macro.MacroParameters;
import com.comalatech.confluence.adhoclists.model.Filter;
import com.comalatech.confluence.adhoclists.model.ResolvedFilter;
import com.comalatech.confluence.adhoclists.module.GlobalConfigManager;
import com.comalatech.confluence.adhoclists.storage.BoardManager;
import com.comalatech.confluence.adhoclists.utils.AdhocListsUtils;
import com.comalatech.confluence.boards.model.Board;
import com.comalatech.confluence.boards.model.BoardViewContext;
import com.comalatech.confluence.boards.renderer.BoardExportRenderer;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoardMacro
extends ConditionalMacro {
    private static final Logger log = LoggerFactory.getLogger(BoardMacro.class);
    public static final String PARAM_LABELS = "labels";
    protected static final String PARAM_READ_ONLY = "readonly";
    protected static final String PARAM_PARENT = "parent";
    private static final String PARAM_SPACEKEY = "spacekey";
    public static final String[] PARAM_NAME = new String[]{"name", "0"};
    protected final BoardManager boardManager;
    protected final BoardRenderer boardRenderer;
    protected final BoardExportRenderer boardExportRenderer;
    protected final FilterManager filterManager;
    private final PermissionManager permissionManager;
    private final BoardCreator boardCreator;
    private final ComalaI18nBean comalaI18nBean;
    protected final CardManager cardManager;
    protected final PageManager pageManager;
    protected final GlobalConfigManager globalConfigManager;

    public BoardMacro(RestCondition restCondition, SpaceManager spaceManager, BoardManager boardManager, BoardRenderer boardRenderer, BoardExportRenderer boardExportRenderer, BoardCreator boardCreator, FilterManager filterManager, AdhocLicenseManager licenseManager, PermissionManager permissionManager, CardManager cardManager, PageManager pageManager, GlobalConfigManager globalConfigManager, ComalaI18nBean comalaI18nBean) {
        super(restCondition, spaceManager, licenseManager);
        this.boardManager = boardManager;
        this.boardRenderer = boardRenderer;
        this.boardExportRenderer = boardExportRenderer;
        this.boardCreator = boardCreator;
        this.filterManager = filterManager;
        this.permissionManager = permissionManager;
        this.cardManager = cardManager;
        this.pageManager = pageManager;
        this.globalConfigManager = globalConfigManager;
        this.comalaI18nBean = comalaI18nBean;
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        Parameters params = new Parameters(parameters, body, renderContext);
        return this.renderBoard(params);
    }

    protected String renderBoard(Parameters params) throws MacroException {
        if (!params.preview) {
            this.checkDisplayPermission(this, params.spaceKey, ConditionalMacro.MacroCondition.SHOWBOARD);
        }
        Board board = this.getBoard(params);
        BoardViewContext viewContext = this.makeBoardViewContext(params, board);
        try {
            viewContext.setPage(params.getAbstractPage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setViewPermissions(viewContext, params);
        ResolvedFilter filter = this.filterManager.resolve(params.filter, viewContext);
        if (params.preview) {
            return this.boardRenderer.renderPreview(viewContext, board, filter);
        }
        this.syncCards(params, board, viewContext.getPage());
        if (board.isCardsOnlyBoard()) {
            viewContext.setCardsOnly();
        } else if (board.isPagesOnlyBoard()) {
            viewContext.setPagesOnly();
        }
        if (List.of("pdf", "word").contains(params.outputType)) {
            return this.boardExportRenderer.renderEmbedded(viewContext, board, filter);
        }
        return this.boardRenderer.renderEmbedded(viewContext, board, filter);
    }

    private BoardViewContext makeBoardViewContext(Parameters params, Board board) {
        BoardViewContext boardViewContext = new BoardViewContext(params.spaceKey, board.getAllKeys());
        int max = AdhocListsUtils.retrieveMaximumRowsForBoard(this.globalConfigManager, board.getMaxRows(), this.getLicenseManager().isLicensed());
        List<String> supportedExportFormats = Arrays.asList("pdf", "word");
        if (supportedExportFormats.contains(params.outputType)) {
            boardViewContext.setPageExport(true);
        }
        boardViewContext.setHostPageIncluded(params.hostPageIncluded);
        boardViewContext.setCount(max);
        return boardViewContext;
    }

    public void syncCards(Parameters params, Board board, AbstractPage page) {
        log.error("Adhoc Board must be an Xhtml Macro");
    }

    private void setViewPermissions(BoardViewContext viewContext, Parameters parameters) {
        if (parameters.readOnly || viewContext.getPage() == null) {
            viewContext.setReadOnly(true);
            return;
        }
        viewContext.setReadOnly(AuthenticatedUserThreadLocal.get() == null || !this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.EDIT, (Object)viewContext.getPage()) || !this.getLicenseManager().isLicensed());
    }

    protected Board getBoard(Parameters parameters) throws MacroException {
        Board board;
        if (StringUtils.isNotBlank((CharSequence)parameters.body)) {
            board = (Board)this.boardManager.parseJson(parameters.body);
            if (board == null) {
                throw new MacroException("Error parsing board " + parameters.name);
            }
        } else {
            board = (Board)this.boardManager.get(parameters.spaceKey, parameters.name);
            if (board == null) {
                board = (Board)this.boardManager.get(parameters.name);
            }
            if (board == null && this.comalaI18nBean.getText("title.labels.popular").equals(parameters.name)) {
                board = this.boardCreator.createPopularLabelsBoard(parameters.spaceKey);
            }
        }
        if (board == null) {
            throw new MacroException("board '" + parameters.name + "' does not exist");
        }
        return board;
    }

    public boolean hasBody() {
        return true;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    private static boolean getBooleanValue(Map<String, Object> parameters, String key, boolean defaultValue) {
        if (parameters == null || !parameters.containsKey(key)) {
            return defaultValue;
        }
        Object value = parameters.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        return defaultValue;
    }

    protected static class Parameters
    extends MacroParameters {
        String name;
        boolean preview;
        String body;
        boolean readOnly;
        Filter filter;
        String spaceKey;
        String outputType;
        boolean hostPageIncluded;

        public Parameters(Map parameters, String body, RenderContext renderContext) throws MacroException {
            super(parameters, renderContext);
            this.spaceKey = ((PageContext)renderContext).getSpaceKey();
            this.filter = new Filter();
            this.filter.setParent(this.get(BoardMacro.PARAM_PARENT));
            this.filter.setAllSpaces(Boolean.parseBoolean((String)parameters.get("allSpaces")));
            this.filter.setSpaceKey(this.get(BoardMacro.PARAM_SPACEKEY));
            this.filter.setLabels(Arrays.asList(AdhocListsUtils.splitAndTrim(this.get(BoardMacro.PARAM_LABELS))));
            this.filter.setDepth(StringUtils.isNotBlank((CharSequence)((String)parameters.get("depth"))) ? Integer.parseInt((String)parameters.get("depth")) : 0);
            this.name = this.get(PARAM_NAME, true);
            this.readOnly = BoardMacro.getBooleanValue(parameters, BoardMacro.PARAM_READ_ONLY, false);
            if (StringUtils.isNotBlank((CharSequence)body) && StringUtils.isNotBlank((CharSequence)(body = AdhocListsUtils.clean(body)))) {
                this.body = body.trim();
            }
            this.outputType = renderContext.getOutputType();
            this.hostPageIncluded = ((PageContext)renderContext).getOriginalContext().getEntity().getId() != ((PageContext)renderContext).getEntity().getId();
            this.readOnly = !this.readOnly && this.hostPageIncluded ? this.hostPageIncluded : this.readOnly;
        }
    }
}

