/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.action;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.core.util.PairType;
import com.atlassian.plugin.PluginController;
import com.atlassian.user.User;
import com.atlassian.xwork.ParameterSafe;
import com.atlassian.xwork.RequireSecurityToken;
import com.comalatech.confluence.adhoclists.metadata.DefaultMetadataAccessor;
import com.comalatech.confluence.adhoclists.model.GlobalConfig;
import com.comalatech.confluence.adhoclists.module.GlobalConfigManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class GlobalConfigAction
extends ConfluenceActionSupport {
    public static final List<String> RESERVED_KEYS = List.of("ANY", "NONE");
    private int maxBoardRows = 20;
    private int maxListRows = 20;
    private boolean editMode;
    private GlobalConfigManager globalConfigManager;
    private SpaceManager spaceManager;
    private PluginController pluginController;
    private DefaultMetadataAccessor metadataAccessor;
    private Map<String, String> showHideMap;
    private GlobalConfig.MetadataAccessorType metadataAccessorType;
    private boolean showMacroBody;
    private boolean notifyOwnChanges = false;
    private boolean collectStats = false;
    public static final String EDITOR_CONTENT_RESOURCES = "com.comalatech.adhoccanvas:editor-contentresources";

    public String doEdit() {
        this.editMode = true;
        return "success";
    }

    @RequireSecurityToken(value=true)
    public String doSave() {
        if (this.hasActionErrors()) {
            return "input";
        }
        GlobalConfig config = this.globalConfigManager.loadGlobalConfig();
        if (this.showHideMap != null) {
            config.setShowHideMap(this.showHideMap);
            this.addActionMessage("Configuration updated");
        }
        config.setMaxBoardRows(this.maxBoardRows);
        config.setMaxListRows(this.maxListRows);
        config.setNotifyOwnChanges(this.notifyOwnChanges);
        config.setNoStats(!this.collectStats);
        config.setMetadataAccessorType(this.metadataAccessorType);
        this.globalConfigManager.storeGlobalConfig(config);
        this.metadataAccessor.setMetadataAccessorDelegate(null);
        this.setMacroBodyVisibility();
        this.editMode = false;
        return "success";
    }

    public void validate() {
        if (this.showHideMap == null) {
            return;
        }
        if (this.maxBoardRows > 100) {
            this.addActionError("Maximum Board Macro Rows setting value ('" + this.maxBoardRows + "') is higher than the allowed maximum limit (100)");
        } else if (this.maxBoardRows <= 0) {
            this.addActionError("Maximum Board Macro Rows setting value ('" + this.maxBoardRows + "') is '0' or lower");
        }
        if (this.maxListRows > 100) {
            this.addActionError("Maximum List Macro Rows setting value ('" + this.maxListRows + "') is higher than the allowed maximum limit (100)");
        } else if (this.maxListRows <= 0) {
            this.addActionError("Maximum List Macro Rows setting value ('" + this.maxListRows + "') is '0' or lower");
        }
        HashSet<String> verifiedSpacekeys = new HashSet<String>();
        HashSet<String> bogusSpacekeys = new HashSet<String>();
        StringBuilder sB = new StringBuilder();
        for (String k : this.showHideMap.keySet()) {
            String[] spaces;
            for (String space : spaces = this.showHideMap.get(k).split(",\\s*")) {
                String spaceKey = space.trim().toUpperCase();
                if (!StringUtils.isNotBlank((CharSequence)spaceKey) || verifiedSpacekeys.contains(spaceKey) || bogusSpacekeys.contains(spaceKey) || RESERVED_KEYS.contains(spaceKey)) continue;
                if (this.spaceManager.getSpace(spaceKey) != null) {
                    verifiedSpacekeys.add(spaceKey);
                    continue;
                }
                if (bogusSpacekeys.contains(spaceKey)) continue;
                bogusSpacekeys.add(spaceKey);
                sB.append(space + " ");
            }
        }
        if (sB.length() > 0) {
            this.addActionError("Space(s) " + HtmlUtil.htmlEncode((String)sB.toString()) + " are not defined");
        }
    }

    private void setMacroBodyVisibility() {
        if (this.showMacroBody) {
            this.pluginController.disablePluginModule(EDITOR_CONTENT_RESOURCES);
        } else {
            this.pluginController.enablePluginModule(EDITOR_CONTENT_RESOURCES);
        }
    }

    public boolean isPermitted() {
        return super.isPermitted() && this.permissionManager.isConfluenceAdministrator((User)this.getAuthenticatedUser());
    }

    public int getMaxBoardRows() {
        return this.globalConfigManager.loadGlobalConfig().getMaxBoardRows();
    }

    @ParameterSafe
    public void setMaxBoardRows(int maxBoardRows) {
        this.maxBoardRows = maxBoardRows;
    }

    public int getMaxListRows() {
        return this.globalConfigManager.loadGlobalConfig().getMaxListRows();
    }

    @ParameterSafe
    public void setMaxListRows(int maxListRows) {
        this.maxListRows = maxListRows;
    }

    public String getShowBoardSpaces() {
        return this.loadMap().get(".showBoardSpaces");
    }

    @ParameterSafe
    public void setShowBoardSpaces(String showBoardSpaces) {
        this.loadMap().put(".showBoardSpaces", showBoardSpaces);
    }

    public String getHideBoardSpaces() {
        return this.loadMap().get(".hideBoardSpaces");
    }

    @ParameterSafe
    public void setHideBoardSpaces(String hideBoardSpaces) {
        this.loadMap().put(".hideBoardSpaces", hideBoardSpaces);
    }

    public String getShowListSpaces() {
        return this.loadMap().get(".showListSpaces");
    }

    @ParameterSafe
    public void setShowListSpaces(String showListSpaces) {
        this.loadMap().put(".showListSpaces", showListSpaces);
    }

    public String getHideListSpaces() {
        return this.loadMap().get(".hideListSpaces");
    }

    @ParameterSafe
    public void setHideListSpaces(String hideListSpaces) {
        this.loadMap().put(".hideListSpaces", hideListSpaces);
    }

    public Map<String, String> loadMap() {
        if (this.showHideMap != null) {
            return this.showHideMap;
        }
        this.showHideMap = this.globalConfigManager.loadGlobalConfig().getShowHideMap();
        return this.showHideMap;
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    @ParameterSafe
    public void setEditMode(boolean editMode) {
        this.editMode = editMode;
    }

    @ParameterSafe
    public void setShowMacroBody(boolean showMacroBody) {
        this.showMacroBody = showMacroBody;
    }

    public boolean isShowMacroBody() {
        return !this.pluginAccessor.isPluginModuleEnabled(EDITOR_CONTENT_RESOURCES);
    }

    public boolean isNotifyOwnChanges() {
        return this.globalConfigManager.loadGlobalConfig().isNotifyOwnChanges();
    }

    @ParameterSafe
    public void setNotifyOwnChanges(boolean notifyOwnChanges) {
        this.notifyOwnChanges = notifyOwnChanges;
    }

    public boolean isCollectStats() {
        return false;
    }

    @ParameterSafe
    public void setCollectStats(boolean collectStats) {
        this.collectStats = collectStats;
    }

    public List<PairType> getMetadataAccessorTypes() {
        ArrayList<PairType> types = new ArrayList<PairType>();
        for (GlobalConfig.MetadataAccessorType t : GlobalConfig.MetadataAccessorType.values()) {
            types.add(new PairType((Serializable)((Object)t.name()), (Serializable)((Object)t.name())));
        }
        return types;
    }

    public String getMetadataAccessorType() {
        GlobalConfig.MetadataAccessorType metadataAccessorType = this.globalConfigManager.loadGlobalConfig().getMetadataAccessorType();
        return Objects.isNull(metadataAccessorType) ? null : metadataAccessorType.name();
    }

    @ParameterSafe
    public void setMetadataAccessorType(String metadataAccessorType) {
        this.metadataAccessorType = GlobalConfig.MetadataAccessorType.valueOf(metadataAccessorType);
    }

    public void setGlobalConfigManager(GlobalConfigManager globalConfigManager) {
        this.globalConfigManager = globalConfigManager;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setMetadataAccessor(DefaultMetadataAccessor metadataAccessor) {
        this.metadataAccessor = metadataAccessor;
    }

    public void setPluginController(PluginController pluginController) {
        this.pluginController = pluginController;
    }

    public boolean showDisableAnalyticsToggleButton() {
        return true;
    }
}

