/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

/**
 * Represents a wiki markup to be rendered
 * @type {*}
 */
WikiMarkup = Backbone.Model.extend({

    initialize: function() {
        // TODO perhaps more clean to use this.set('url') here
        this.url = AJS.$('meta[name=context-path]').attr("content") + "/rest/adhoclists/1/exchange/boards/wiki";
    },

    render: function() {
        this.fetch({
            data: JSON.stringify({
                wiki: this.get("wiki")
            }),
            type : "POST",
            contentType: "application/json"
        });
    }
});

var Wiki = Backbone.View.extend({
    model: WikiMarkup,
    className: "renderedWiki",

    initialize : function(wiki) {
        this.model = new WikiMarkup({
            wiki: wiki
        });
        this.model.bind("change", this.loadHtml, this);
    },

    render: function() {
        this.model.render();
        return this;
    },

    loadHtml: function() {
        this.$el.html(this.model.get("wikiHtml"));
        // making all the links in the description to open in new window
        this.$el.find("a").attr("target", "_blank");
    }
});