/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var Adhoc = Adhoc || {};
Adhoc.common = Adhoc.common || {};
Adhoc.common.initialized = Adhoc.common.initialized || false;

var Canvas = Canvas || {};
Canvas.initializedScripts = Canvas.initializedScripts || {};

var requirejs = require || requirejs;

(function ($) {
    if (Adhoc.common.initialized) {
        return;
    } else {
        Adhoc.common.initialized = true;
    }

    Canvas.initialized = function(key) {
        if (Canvas.initializedScripts[key]) {
            return true;
        } else {
            Canvas.initializedScripts[key] = true;
            return false;
        }
    };

    var confirmDialog = {
        width:250,
        height:"12em",
        id:"confirmDialog"
    };

    var feedbackDialog;

    Adhoc.common.errorMessage = function($container, message, millis) {
        var $target;
        if ($container.hasClass("adhocerror")) {
            $target = $container;
        } else {
            $target = $(".adhocerror", $container);
            if ($target == undefined || $target.length == 0) {
                $container.append("<div class='adhocerror'></div>");
                $target = $(".adhocerror", $container);
            }
        }
        $target.html(message).hide().removeClass("hidden").fadeIn("slow");
        if (millis && millis > 0) {
            setTimeout(function () {
                $target.fadeOut();
            }, millis);
        }
    };

    Adhoc.common.clearErrorMessage = function($container) {
        var $target;
        if ($container.hasClass("adhocerror")) {
            $target = $container;
        } else {
            $target = $(".adhocerror", $container);
        }
        $target.html("").addClass("hidden");
    };

    Adhoc.common.errorHandlerFadeOut = function($container, jqXHR, textStatus, errorThrown, fadeOutEnabled) {
        try {
            if (jqXHR.status == 400) {
                var message;
                if (jqXHR.responseText.indexOf("<html>") >= 0) {
                    message = jqXHR.statusText;
                } else {
                    message = jqXHR.responseText;
                }
                var fadeOutMillis = 0;
                if(fadeOutEnabled){
                    fadeOutMillis = 2000;
                }

                Adhoc.common.errorMessage($container,message,fadeOutMillis);
                return;
            } else {
                Adhoc.errorData = jqXHR;
                Adhoc.errorStatus = textStatus;
                if (errorThrown && errorThrown.length > 0) {
                    var theMessage = "Server error (" + errorThrown + "). Try reloading the page";
                    Adhoc.common.errorMessage($container, theMessage);
                }
            }
        } catch (e) {
        }
        AJS.log(errorThrown + ". Check Adhoc.errorData and Adhoc.errorStatus");
    };

    Adhoc.common.errorHandler = function($container, jqXHR, textStatus, errorThrown) {
        Adhoc.common.errorHandlerFadeOut($container, jqXHR, textStatus, errorThrown, true);
    };

    Adhoc.common.isValidLabel = function( label ){
        if (! label || label.length == 0) {
            return false;
        }
        var uppercaseOrSpacePattern = /[A-Z\s]/g;
        var isSpecialCharacter = label.match(/[:;?&\[\]\(\)#\^!<>~\*]+/i) != null;
        var isUpperCaseAndSpace = uppercaseOrSpacePattern.test( label );
        return !isSpecialCharacter && !isUpperCaseAndSpace;
    };

    Adhoc.common.convertToLabel = function (input) {
        var specialCharacter = /[\s:;\.?&\[\]\(\)#\^!<>~\*]+/g; // allowing the @ character deliberately
        var lo = input.toLowerCase();
        return lo.replace(specialCharacter, '')
    };

    Adhoc.common.getSuggestedLabels = function( spaceKey, callback ){
        var url = AJS.Confluence.getContextPath() + "/rpc/json-rpc/confluenceservice-v2/getMostPopularLabelsInSpace";
        $.ajax({
            type : 'post',
            contentType: "application/json; charset=utf-8",
            url : url,
            data : JSON.stringify( [ spaceKey, 25 ] ),
            dataType : 'json'})
                .done( function(data){
                    callback( data )
                } );
    };

    /**
     * Create feedback link (loads wufoo feedback form)
     */
    Adhoc.common.feedbackFormLink = function (formId) {
        var feedbackLink = '';
        
        if(formId != '') {
            var feedbackLink = $(document.createElement('a'))
            .attr({
                href : '#',
                'formid' : formId
            })
            .addClass('canvasfeedback canvasfeedback-dialog')
            .html(AJS.I18n.getText('adhoclists.feedback'));
        }
        else {
            AJS.log('[adhoc.common:warning] Missing form ID @feedbackFormLink');
        }
        return feedbackLink;
    };

    Adhoc.addLargeSpinner = function($content) {
        $content.empty()
            .append('<div class="cb-spinner"><aui-spinner size="large"></aui-spinner></div>');
    };

    Adhoc.addMediumSpinner = function($content) {
        $content.empty()
            .append('<div class="cb-spinner"><aui-spinner size="medium"></aui-spinner></div>');
    };

    Adhoc.addSmallSpinner = function($content) {
        $content.empty()
            .append('<div class="cb-spinner"><aui-spinner size="small"></aui-spinner></div>');
    };

    Adhoc.doIfconfirm = function(header, message, action){
        confirmDialog = new Canvas.CML.Dialog({
            id: "confirmDialog",
            size: 'small',
            title: header,
            content: message,
            actions: [
                {
                    id: 'Yes',
                    style: 'primary',
                    label: AJS.I18n.getText("yes.name"),
                    onClick: function() {
                        action();
                        confirmDialog.hide();
                    }
                },
                {
                    id: 'No',
                    style: 'default',
                    label: AJS.I18n.getText("no.name"),
                    onClick: function () {
                        confirmDialog.hide();
                    }
                },
            ]
        });
        confirmDialog.show();
    };

    Adhoc.previewPage = function(pageId, $pageContent,$trigger) {
        if (! $trigger.hasClass("hovering")) {
            return;
        }
        $.ajax({
            type: "GET",
            cache: false,
            url: AJS.Confluence.getContextPath() + "/rest/adhoclists/latest/lists/" + pageId + "/render",
            success: function (data, textStatus, jqXHR) {
                if ($trigger.hasClass("hovering")) {
                    $pageContent.html(data);
                    $("#inline-dialog-pagePopup .contents").css("width","auto");
                }
            },
            error: function(error, data) {
            }
        });
    };

    Adhoc.createPagePopupDialog = function(InlineDialog) {
        var $content = InlineDialog.getContainer();
        var $trigger = $(InlineDialog.trigger);
        $("a.pagelink, a.cardlink").removeClass("hovering");
        $trigger.addClass("hovering");

        var pageId = InlineDialog.$el.data("pageid") || 0;
        if (pageId > 0) {
            // render only if not empty
            hoverPage(pageId, $content, $trigger);
        } else {
            // Option A: card preview with card look
            $content.removeClass('themedheader card');
            if (typeof InlineDialog.$el.attr('data-themecolor') != 'undefined' && InlineDialog.$el.attr('data-themecolor') != '') {
                InlineDialog.$el.removeClass(InlineDialog.$el.attr('data-themecolor'));
                InlineDialog.$el.attr('data-themecolor', '');
            }

            hoverCard($content, $trigger);

            // Option A: card preview with card look
            $content.addClass('themedheader card');
            var themeColor = $trigger
                                .parents('.boardcontainer')
                                .attr('containerstyle');

            InlineDialog.$el
                .addClass(themeColor)
                .attr('data-themecolor', themeColor);
        }

        $("#arrow-pagePopup").hide();
    };

    Adhoc.initializePagePopupDialog = function () {
        var id, trigger;
        if (arguments.length > 1) {
            trigger = arguments[1];
            id = arguments[0];
        } else {
            trigger = arguments[0];
            id = trigger.id;
        }
        // also, look at styles.css for max/min width/height
        requirejs(['cb'], function (CB) {
            var pagePopupDialog = new CB.InlineDialog({
                id: 'pagePopup-' + id,
                trigger: trigger.tagName + '#' + trigger.id + '.' + trigger.className.replace(' ', '.'),
                width: 300,
                content: Adhoc.createPagePopupDialog,
                alignment: 'bottom left',
                attributes: {
                    'data-pageid': trigger.getAttribute('pageid')
                },
                'responds-to': 'hover',
                className: 'cc-inline-dialog-pagePopup'
            });
            $(document.body).append(pagePopupDialog.render());
        });
    };

    var hoverPage = function(pageId, $content, $trigger) {
        if (! $trigger.hasClass("hovering")) {
            return;
        }
        $.ajax({
            type:"GET",
            cache:false,
            url:AJS.Confluence.getContextPath() + "/rest/adhoclists/latest/lists/" + pageId + "/metadata",
            success:function (data, textStatus, jqXHR) {
                if (!$trigger.hasClass("hovering")) {
                    return;
                }
                $content.html(data);
                Adhoc.addSmallSpinner($("#inline-dialog-pagePopup .previewpage"));
                var $pageContent = $(".page-body", $content);
                setTimeout(function () {
                    Adhoc.previewPage(pageId, $pageContent, $trigger);
                }, 200);
            },
            error:function (error, data) {
            }
        });
    };

    /**
     * Removes unwanted markup from provided string
     * @param content
     * @returns {string}
     */
    Adhoc.sanitizeBoardContent = function(content) {
        return content.replace("//<![CDATA[", "").replace("//]]>", "")
    };

    var hoverCard = function($content, $trigger) {
        if (! $trigger.hasClass("hovering")) {
            return;
        }
        var filterLabels = "";
        var $card = $trigger.parents(".boardcontent");
        if ($card.length == 0) {
            return;
        }
        var card = {};
        card.title = $(".cardtitle",$card).text();
        card.labels = $card.parents(".boardcontainer").attr("containerid").split(",");
        if (filterLabels.length ){
            card.labels.push(filterLabels.split(","));
        }
        $content.html(Adhoc.sanitizeBoardContent(AJS.template.load("card-popup").fill(card).toString()));

        $(".previewpage",$content).html($(".renderedbody",$card).html());

        for (var i = 0; i < card.labels.length && card.labels[i].length>0;i++) {
            $(".labelslist",$content).append("<li>" + card.labels[i] + "</li>");
        }
    };

    $.fn.extend({
        toggleButton: function($input) {
            var hasValues = true;
            hasValues = true;
            $input.each(function() {
                hasValues = hasValues && $(this).val().length > 0;
            });
            if (hasValues) {
                $(this).removeAttr("disabled");
            } else {
                $(this).prop("disabled","disabled");
            }
        }
    });

    AJS.toInit(function ($) {
        AJS.log("init common");
        requirejs(['cb'], function (CB) {
            // also, look at styles.css for max/min width/height
            $("a.pagelink[id],a.cardlink[id]").each(function(index) {

                var pagelink = this.tagName + '#' + this.id + '.' + this.className.replace(' ', '.');
                var wrapperclass = 'wrapper_' + this.id;
                
                $(pagelink).wrap('<span class="' + wrapperclass + '"></span>');

                var pagePopupDialog = new CB.InlineDialog({
                    id: 'pagePopup' + index,
                    trigger: '.' + wrapperclass,
                    width: 300,
                    content: Adhoc.createPagePopupDialog,
                    alignment: 'bottom left',
                    attributes: {
                        'data-pageid': this.getAttribute('pageid')
                    },
                    'responds-to': 'hover',
                    className: 'cc-inline-dialog-pagePopup'
                });
                $(document.body).append(pagePopupDialog.render());
            });
        });
        // feedback stuff
        $(document).on("click", "a.canvasfeedback", function(event) {
            event.preventDefault();
            var formId = $(this).attr("formid");
            var form = "<iframe height='360' allowTransparency='true' frameborder='0' " +
                    "scrolling='no' style='width:100%;border:none' src='" +
                    "https://comalatech.wufoo.com/embed/" +
                    formId +
                    "/'><a href='" +
                    "https://comalatech.wufoo.com/forms/" +
                    formId +
                    "/'>Fill out my Wufoo form!</a></iframe>";
            feedbackDialog = new Canvas.CML.Dialog({
                width:600,
                height:380,
                id:"feedback-dialog",
                // title: AJS.I18n.getText("adhoclists.feedback"),
                content: form
            });
            feedbackDialog.show();
        });
    });
})(AJS.$);
