/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

(function ($) {
    if (Canvas.initialized("selectlabel.cell")) {
        return;
    }

    AJS.toInit(function ($) {
        AJS.log("init selectlabel.cell");
        $(document).on('change', ".adhocchecklist.view select.selectlabel", function() {
            var selected = $(this).find("option:selected").val();
            var $cell = $(this).parents("td.cell-selectlabel");
            var pageId = Adhoc.Checklist.rowId($cell);
            var otherLabels = "";
            var separator = "";
            $("option",$(this)).each(function() {
                var label = $(this).val();
                if (label != selected && label.length > 0) {
                    otherLabels = otherLabels + separator + label;
                    separator =",";
                }
            });
            if (! Adhoc.Checklist.empty($cell)) {
                $.ajax({
                    type: "POST",
                    cache: false,
                    contentType: "application/json",
                    url: AJS.Confluence.getContextPath() + "/rest/adhoclists/latest/lists/label/" +
                            Adhoc.Checklist.rowId($cell) +
                            "/toggle?label=" + encodeURIComponent(selected) +
                            "&labels=" + encodeURIComponent(otherLabels),
                    success: function (action, textStatus, jqXHR) {
                        $("span.sortvalue",$cell).html(selected);
                        $(".adhocchecklist.view").trigger("update");
                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        Adhoc.common.errorHandler($cell.parents("tr.page"),jqXHR, textStatus,errorThrown);
                    }
                });
            }
        });
        $(document).on('resetcell', "tr.newpagerow td.cell-selectlabel", function(event) {
            $("select option",$(this)).each(function() {
                $(this).removeAttr("selected");
            });
        });
        $(document).on('initcell', "tr.newpagerow td.cell-selectlabel", function(event,$newrow) {
            var $cell = $(this);
            var $newCell = $("td:nth-child(" + $cell.attr("index") + ")",$newrow);
            var selected = $("option:selected",$cell).val();
            if (selected && selected.length > 0) {
                $("option[value='" + selected + "']",$newCell).prop("selected","selected");
                $("select.selectlabel",$newCell).change();
            }
        });
    });
})(AJS.$);