/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

(function ($) {
    if (Canvas.initialized("input.cell")) {
        return;
    }

    AJS.toInit(function ($) {
        AJS.log("init input.cell");
        $(document).on('click', ".adhocchecklist.view .cell-input .editlink", function() {
            var $cell = $(this).parents(".cell-input");
            var $input = $cell.find("input[type='text']");
            if ($cell.hasClass("edit")) {
                return;
            }
            $cell.find(".cell-input-element").removeClass("hidden");
            $(".cell-input").removeClass("edit");
            $cell.addClass("edit");
            $input.focus();
        });
        $(document).on('click', ".cell-input a.cancelinput", function() {
            var $cell = $(this).parents("td.cell-input");
            $cell.find(".cell-input-element").addClass("hidden");
            $cell.removeClass("edit");
            return false;
        });
        $(document).on('click', ".cell-input input.acceptinput", function() {
            var $cell = $(this).parents("td.cell-input");
            var pageId = Adhoc.Checklist.rowId($cell);
            var $input = $cell.find("input[type='text']");
            var valueName = $input.attr("name");
            var value = $input.val();
            $.ajax({
                type: "POST",
                cache: false,
                data:  value,
                contentType: "application/json",
                url: AJS.Confluence.getContextPath() + "/rest/adhoclists/latest/lists/metadata/" +
                        pageId +
                        "/set?valueName=" + encodeURIComponent(valueName),
                success: function (action, textStatus, jqXHR) {
                    $cell.find(".cell-value").html(AJS.escapeHtml(value));
                    $(".adhocchecklist.view").trigger("update");
                    $cell.removeClass("edit");
                    $cell.find(".cell-input-element").addClass("hidden");
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    Adhoc.common.errorHandler($cell.parents("tr.page"),jqXHR, textStatus,errorThrown);
                }
            });
            return false;
        });
        $(document).on('resetcell', "tr.newpagerow td.cell-input", function(event) {
            $("input",$(this)).val("");
        });
        $(document).on('initcell', "tr.newpagerow td.cell-input", function(event,$newrow) {
            var $cell = $(this);
            var $newCell = $("td:nth-child(" + $cell.attr("index") + ")",$newrow);
            var value = $("input[type='text']",$cell).val();
            if (value && value.length > 0) {
                $("input[type='text']",$newCell).val(value);
                $("input.acceptinput",$newCell).click();
            }
        });
    });
})(AJS.$);
