/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.boards.service;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentBody;
import com.atlassian.confluence.api.model.content.ContentRepresentation;
import com.atlassian.confluence.api.model.content.ContentStatus;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.comalatech.confluence.adhoclists.boards.events.BoardPageCreatedEvent;
import com.comalatech.confluence.adhoclists.boards.events.CardCreatedEvent;
import com.comalatech.confluence.adhoclists.boards.events.CardMovedOnBoardEvent;
import com.comalatech.confluence.adhoclists.boards.events.CardUpdatedEvent;
import com.comalatech.confluence.adhoclists.boards.view.LabelBoardResolver;
import com.comalatech.confluence.adhoclists.boards.view.model.RenderedCard;
import com.comalatech.confluence.adhoclists.boards.view.model.ResolvedContainer;
import com.comalatech.confluence.adhoclists.boards.view.model.SimplifiedCard;
import com.comalatech.confluence.adhoclists.cards.CardManager;
import com.comalatech.confluence.adhoclists.cards.model.Card;
import com.comalatech.confluence.adhoclists.cards.model.Cards;
import com.comalatech.confluence.adhoclists.cards.model.ResolvedCard;
import com.comalatech.confluence.adhoclists.license.AdhocLicenseManager;
import com.comalatech.confluence.adhoclists.model.Filter;
import com.comalatech.confluence.adhoclists.model.ResolvedFilter;
import com.comalatech.confluence.adhoclists.module.GlobalConfigManager;
import com.comalatech.confluence.adhoclists.rest.PermissionRequired;
import com.comalatech.confluence.adhoclists.templates.AdhocTemplateManager;
import com.comalatech.confluence.adhoclists.utils.AdhocListsUtils;
import com.comalatech.confluence.boards.exception.ComalaBoardsException;
import com.comalatech.confluence.boards.exception.ComalaBoardsRestException;
import com.comalatech.confluence.boards.model.Board;
import com.comalatech.confluence.boards.model.BoardViewContext;
import com.comalatech.confluence.boards.model.Container;
import com.comalatech.confluence.boards.rest.model.BoardCards;
import com.comalatech.confluence.boards.rest.model.NewCard;
import com.comalatech.confluence.boards.rest.model.PageBasicInfo;
import com.comalatech.confluence.boards.service.BoardCqlSearchService;
import com.comalatech.confluence.boards.service.BoardService;
import com.comalatech.confluence.boards.util.BoardUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class BoardServiceImpl
implements BoardService {
    private final CardManager cardManager;
    private final LabelManager labelManager;
    private final PageManager pageManager;
    private final PageTemplateManager pageTemplateManager;
    private final TransactionTemplate transactionTemplate;
    private final GlobalConfigManager globalConfigManager;
    private final AdhocLicenseManager licenseManager;
    private final LabelBoardResolver labelBoardResolver;
    private final XhtmlContent xhtmlContent;
    private final ContentService contentService;
    private final I18nResolver i18nResolver;
    private final PermissionManager permissionManager;
    private final EventPublisher eventPublisher;
    private final UserAccessor userAccessor;
    private final AdhocTemplateManager adhocTemplateManager;
    private final BoardCqlSearchService boardCqlSearchService;

    @Autowired
    public BoardServiceImpl(CardManager cardManager, @ComponentImport LabelManager labelManager, @ComponentImport PageManager pageManager, @ComponentImport PageTemplateManager pageTemplateManager, @ComponentImport TransactionTemplate transactionTemplate, GlobalConfigManager globalConfigManager, AdhocLicenseManager licenseManager, LabelBoardResolver labelBoardResolver, @ComponentImport XhtmlContent xhtmlContent, @ComponentImport @Qualifier(value="contentService") ContentService contentService, @ComponentImport I18nResolver i18nResolver, @ComponentImport PermissionManager permissionManager, @ComponentImport EventPublisher eventPublisher, @ComponentImport UserAccessor userAccessor, AdhocTemplateManager adhocTemplateManager, BoardCqlSearchService boardCqlSearchService) {
        this.cardManager = cardManager;
        this.labelManager = labelManager;
        this.pageManager = pageManager;
        this.pageTemplateManager = pageTemplateManager;
        this.transactionTemplate = transactionTemplate;
        this.globalConfigManager = globalConfigManager;
        this.licenseManager = licenseManager;
        this.labelBoardResolver = labelBoardResolver;
        this.xhtmlContent = xhtmlContent;
        this.contentService = contentService;
        this.i18nResolver = i18nResolver;
        this.permissionManager = permissionManager;
        this.eventPublisher = eventPublisher;
        this.userAccessor = userAccessor;
        this.adhocTemplateManager = adhocTemplateManager;
        this.boardCqlSearchService = boardCqlSearchService;
    }

    @Override
    public RenderedCard addPlainCardToBoard(AbstractPage abstractPage, NewCard card) {
        this.transactionTemplate.execute(() -> {
            this.cardManager.addCard((ContentEntityObject)abstractPage, new Card(card), card.getContainerId());
            this.eventPublisher.publish((Object)new CardCreatedEvent());
            return null;
        });
        ResolvedCard resolvedCard = new ResolvedCard(card.getBody());
        this.notifyOnCardCreation(abstractPage, resolvedCard, card.getContainerId());
        RenderedCard renderedCard = this.labelBoardResolver.makeRenderedCard(abstractPage, resolvedCard);
        return new SimplifiedCard(renderedCard);
    }

    @Override
    public void addPlainCardsToBoard(AbstractPage abstractPage, NewCard[] cards) {
        this.transactionTemplate.execute(() -> {
            Arrays.stream(cards).forEach(card -> this.cardManager.addCard((ContentEntityObject)abstractPage, new Card((Card)card), card.getContainerId()));
            this.eventPublisher.publish((Object)new CardCreatedEvent());
            return null;
        });
    }

    @Override
    public RenderedCard updatePlainCards(AbstractPage abstractPage, NewCard[] cards) {
        this.transactionTemplate.execute(() -> {
            NewCard cardToUpdate = cards[0];
            this.cardManager.updateCard((ContentEntityObject)abstractPage, new Card(cardToUpdate), cardToUpdate.getContainerId(), cards[1].getBody());
            this.eventPublisher.publish((Object)new CardUpdatedEvent());
            return null;
        });
        ResolvedCard resolvedCard = new ResolvedCard(cards[1].getBody());
        RenderedCard renderedCard = this.labelBoardResolver.makeRenderedCard(abstractPage, resolvedCard);
        return new SimplifiedCard(renderedCard);
    }

    @Override
    public void deletePlainCardFromBoard(AbstractPage abstractPage, NewCard card) {
        this.transactionTemplate.execute(() -> {
            this.cardManager.moveCard((ContentEntityObject)abstractPage, new Card(card), card.getContainerId(), null, null);
            return null;
        });
    }

    @Override
    public void clearBoard(AbstractPage abstractPage, Board board) {
        this.transactionTemplate.execute(() -> {
            board.getRows().forEach(row -> row.getColumns().forEach(column -> column.getContainers().forEach(container -> {
                String key = container.getKey();
                Cards cards = this.cardManager.getCards((ContentEntityObject)abstractPage, key);
                for (Card card : cards.getForStorage()) {
                    if (!StringUtils.isNotBlank((CharSequence)card.getId())) continue;
                    BoardUtils.getLabelsFromContainerId(key).forEach(label -> this.labelManager.removeLabel((Labelable)this.pageManager.getAbstractPage(Long.parseLong(card.getId())), label));
                }
                this.cardManager.removeCards((ContentEntityObject)abstractPage, key);
            })));
            return null;
        });
    }

    @Override
    public RenderedCard addPageCardToBoard(AbstractPage abstractPage, NewCard card, Long templateId) {
        String containerId = card.getContainerId();
        RenderedCard finalRenderedCard = (RenderedCard)this.transactionTemplate.execute(() -> {
            RenderedCard renderedCard = null;
            if (StringUtils.isNotBlank((CharSequence)card.getBody())) {
                ResolvedCard resolvedCard = new ResolvedCard(card.getBody());
                this.validateNewPageCreation(abstractPage, resolvedCard);
                Page page = this.createNewConfluencePage(abstractPage, containerId, resolvedCard, templateId);
                if (page != null) {
                    this.cardManager.addCard((ContentEntityObject)abstractPage, new Card(Long.toString(page.getId()), null), containerId);
                    renderedCard = new RenderedCard((AbstractPage)page, true);
                }
            } else {
                Page page = this.pageManager.getPage(Long.parseLong(card.getId()));
                this.addLabelsToPage(containerId, (Labelable)page);
                this.cardManager.addCard((ContentEntityObject)abstractPage, new Card(card), containerId);
                renderedCard = new RenderedCard((AbstractPage)page, true);
            }
            this.eventPublisher.publish((Object)new BoardPageCreatedEvent());
            return new SimplifiedCard(renderedCard);
        });
        this.notifyOnCardCreation(abstractPage, new ResolvedCard(finalRenderedCard.getId(), finalRenderedCard.getTitle(), finalRenderedCard.getUrl()), card.getContainerId());
        return finalRenderedCard;
    }

    @Override
    public void deletePageCardFromBoard(AbstractPage abstractPage, NewCard card) {
        String containerId = card.getContainerId();
        this.transactionTemplate.execute(() -> {
            this.cardManager.moveCard((ContentEntityObject)abstractPage, new Card(card), containerId, null, null);
            try {
                Page page = this.pageManager.getPage(Long.parseLong(card.getId()));
                this.removeLabelsFromPage(containerId, (Labelable)page);
            }
            catch (Error | Exception e) {
                throw new ComalaBoardsException(this.i18nResolver.getText("comala-boards.exceptions.service.delete-page-card"), e);
            }
            return null;
        });
    }

    @Override
    public RenderedCard convertPlainCardToPageCard(AbstractPage abstractPage, NewCard card, Long templateId) {
        return (RenderedCard)this.transactionTemplate.execute(() -> {
            String containerId = card.getContainerId();
            Cards cards = this.cardManager.getCards((ContentEntityObject)abstractPage, containerId);
            Card beforeCard = cards.getCardBefore(card);
            this.deletePlainCardFromBoard(abstractPage, card);
            RenderedCard renderedCard = this.addPageCardToBoard(abstractPage, card, templateId);
            this.cardManager.moveCard((ContentEntityObject)abstractPage, renderedCard.toCard(), containerId, containerId, beforeCard);
            return new SimplifiedCard(renderedCard);
        });
    }

    @Override
    public void moveCard(AbstractPage abstractPage, NewCard cardFrom, NewCard cardTo, boolean notify) {
        this.transactionTemplate.execute(() -> {
            if (cardTo != null) {
                ResolvedCard resolvedCard = null;
                if (StringUtils.isNotBlank((CharSequence)cardFrom.getId())) {
                    try {
                        Page page = this.pageManager.getPage(Long.parseLong(cardFrom.getId()));
                        this.removeLabelsFromPage(cardFrom.getContainerId(), (Labelable)page);
                        this.addLabelsToPage(cardTo.getContainerId(), (Labelable)page);
                        resolvedCard = new ResolvedCard(cardFrom.getId(), page.getTitle(), page.getUrlPath());
                    }
                    catch (Error | Exception e) {
                        throw new ComalaBoardsException(this.i18nResolver.getText("comala-boards.exceptions.service.move-card"), e);
                    }
                }
                this.cardManager.moveCard((ContentEntityObject)abstractPage, new Card(cardFrom), cardFrom.getContainerId(), cardTo.getContainerId(), this.isSameBaseCard(cardFrom, cardTo) ? null : new Card(cardTo));
                this.publishCardMoved(abstractPage, cardFrom, cardTo, resolvedCard, notify);
            } else {
                this.cardManager.moveCard((ContentEntityObject)abstractPage, new Card(cardFrom), cardFrom.getContainerId(), cardFrom.getContainerId(), null);
            }
            return null;
        });
    }

    @Override
    public BoardCards resolveBoardCards(AbstractPage abstractPage, Board board, String[] containerIds, int startIndex) {
        ResolvedFilter resolvedFilter = this.getResolvedFilter(abstractPage, board.getFilter());
        BoardViewContext boardViewContext = new BoardViewContext(abstractPage.getSpaceKey(), board.getAllKeys());
        boardViewContext.setCount(AdhocListsUtils.retrieveMaximumRowsForBoard(this.globalConfigManager, board.getMaxRows(), this.licenseManager.isLicensed()));
        boardViewContext.setPage(abstractPage);
        if (containerIds == null || containerIds.length == 0) {
            containerIds = boardViewContext.getAllKeys().toArray(new String[0]);
        }
        HashMap<String, ArrayList<RenderedCard>> containerCards = new HashMap<String, ArrayList<RenderedCard>>();
        HashMap<String, Boolean> containerHasMoreCards = new HashMap<String, Boolean>();
        for (String containerId : containerIds) {
            ResolvedContainer resolvedContainer = this.labelBoardResolver.getExpandedContainer(boardViewContext, resolvedFilter, new Container(containerId), startIndex);
            containerHasMoreCards.put(containerId, resolvedContainer.isHasMoreEntities());
            List cards = resolvedContainer.getEntities().stream().map(SimplifiedCard::new).collect(Collectors.toList());
            containerCards.put(containerId, new ArrayList(cards));
        }
        return new BoardCards(containerCards, containerHasMoreCards);
    }

    @Override
    public Map<String, List<PageBasicInfo>> getAvailablePageTemplates(Space space) {
        List<PageTemplate> spaceTemplates;
        HashMap<String, List<PageBasicInfo>> availablePageTemplates = new HashMap<String, List<PageBasicInfo>>();
        availablePageTemplates.put("globalTemplates", new ArrayList());
        availablePageTemplates.put("spaceTemplates", new ArrayList());
        List<PageTemplate> globalTemplates = this.adhocTemplateManager.getPageTemplates(null);
        if (globalTemplates != null) {
            globalTemplates.forEach(pageTemplate -> ((List)availablePageTemplates.get("globalTemplates")).add(new PageBasicInfo(Long.toString(pageTemplate.getId()), pageTemplate.getName())));
        }
        if ((spaceTemplates = this.adhocTemplateManager.getPageTemplates(space.getKey())) != null) {
            spaceTemplates.forEach(pageTemplate -> ((List)availablePageTemplates.get("spaceTemplates")).add(new PageBasicInfo(Long.toString(pageTemplate.getId()), pageTemplate.getName())));
        }
        return availablePageTemplates;
    }

    @Override
    public List<PageBasicInfo> searchPagesByTitleAndFilter(AbstractPage abstractPage, String searchText, Filter boardFilter, boolean searchAllSpaces) {
        ResolvedFilter resolvedFilter = this.getResolvedFilter(abstractPage, boardFilter);
        if (StringUtils.isBlank((CharSequence)resolvedFilter.getSpaceKey())) {
            resolvedFilter.setSpaceKey(abstractPage.getSpaceKey());
        }
        return this.boardCqlSearchService.searchPagesByTitleAndFilter(searchText, resolvedFilter, searchAllSpaces);
    }

    private void validateNewPageCreation(AbstractPage abstractPage, ResolvedCard resolvedCard) {
        Page page = this.pageManager.getPage(abstractPage.getSpaceKey(), resolvedCard.getTitle());
        if (page != null) {
            throw new ComalaBoardsRestException(Response.Status.CONFLICT.getStatusCode(), this.i18nResolver.getText("comala-boards.exceptions.service.existing-page-error", new Serializable[]{page.getTitle(), page.getSpace().getName()}));
        }
        if (!this.permissionManager.hasCreatePermission(AuthenticatedUserThreadLocal.get(), (Object)abstractPage.getSpace(), Page.class)) {
            throw new ComalaBoardsRestException(PermissionRequired.Type.CREATEPAGE.getHttpErrorCode(), this.i18nResolver.getText("comala-boards.exceptions.service.page-creation-permission", new Serializable[]{abstractPage.getSpace().getName()}));
        }
    }

    private Page createNewConfluencePage(AbstractPage abstractPage, String containerId, ResolvedCard resolvedCard, Long templateId) {
        Page parentPage = abstractPage instanceof Page ? (Page)abstractPage : abstractPage.getSpace().getHomePage();
        Content parentPageContent = Content.builder().id(parentPage.getContentId()).type(ContentType.PAGE).build();
        ContentBody contentBody = new ContentBody(ContentRepresentation.STORAGE, this.xhtmlContent.convertWikiToStorage(resolvedCard.getContent(), (ConversionContext)new DefaultConversionContext((RenderContext)parentPage.toPageContext()), null));
        if (templateId != null) {
            PageTemplate pageTemplate = this.pageTemplateManager.getPageTemplate(templateId.longValue());
            if (pageTemplate != null) {
                contentBody = new ContentBody(ContentRepresentation.STORAGE, BoardUtils.cleanPageContentFor(pageTemplate.getContent()));
            } else {
                throw new ComalaBoardsRestException(Response.Status.BAD_REQUEST.getStatusCode(), this.i18nResolver.getText("comala-boards.exceptions.service.template-not-found", new Serializable[]{templateId.toString()}));
            }
        }
        try {
            Content content = Content.builder().type(ContentType.PAGE).status(ContentStatus.CURRENT).title(resolvedCard.getTitle()).parent(parentPageContent).space(parentPage.getSpaceKey()).body(contentBody).build();
            content = this.contentService.create(content, new Expansion[]{new Expansion("id")});
            Page page = this.pageManager.getPage(content.getId().asLong());
            this.addLabelsToPage(containerId, (Labelable)page);
            return page;
        }
        catch (Error | Exception e) {
            throw new ComalaBoardsException(this.i18nResolver.getText("comala-boards.exceptions.service.create-page-card"), e);
        }
    }

    private void addLabelsToPage(String containerId, Labelable page) {
        if (StringUtils.isNotBlank((CharSequence)containerId)) {
            for (Label label : BoardUtils.getLabelsFromContainerId(containerId)) {
                if (!label.toString().startsWith("@")) {
                    this.labelManager.addLabel(page, label);
                    continue;
                }
                String username = this.getUsernameFromCustomPersonalLabel(label);
                String sanitizedLabel = BoardUtils.getPersonalPageLabelFromUsername(username);
                this.labelManager.addLabel(page, new Label(sanitizedLabel, Namespace.PERSONAL, this.userAccessor.getUserByName(username)));
            }
        }
    }

    private String getUsernameFromCustomPersonalLabel(Label label) {
        return BoardUtils.extractUsernameFromString(label.toString());
    }

    private void removeLabelsFromPage(String containerId, Labelable page) {
        if (StringUtils.isNotBlank((CharSequence)containerId)) {
            for (Label label : BoardUtils.getLabelsFromContainerId(containerId)) {
                if (!label.toString().startsWith("@")) {
                    this.labelManager.removeLabel(page, label);
                    continue;
                }
                String username = this.getUsernameFromCustomPersonalLabel(label);
                String sanitizedLabel = BoardUtils.getPersonalPageLabelFromUsername(username);
                this.labelManager.removeLabel(page, new Label(sanitizedLabel, Namespace.PERSONAL, this.userAccessor.getUserByName(username)));
            }
        }
    }

    private boolean isSameBaseCard(NewCard cardFrom, NewCard cardTo) {
        return cardFrom.equals(cardTo);
    }

    private void notifyOnCardCreation(AbstractPage abstractPage, ResolvedCard resolvedCard, String containerId) {
        for (Label label : BoardUtils.getLabelsFromContainerId(containerId)) {
            String username;
            if (!label.toString().startsWith("@") || StringUtils.equals((CharSequence)(username = this.getUsernameFromCustomPersonalLabel(label)), (CharSequence)AuthenticatedUserThreadLocal.get().getName())) continue;
            CardMovedOnBoardEvent event = new CardMovedOnBoardEvent((ContentEntityObject)abstractPage, resolvedCard, null, label.toString(), Board.Type.LABEL, true);
            this.eventPublisher.publish((Object)event);
        }
    }

    private void publishCardMoved(AbstractPage abstractPage, NewCard cardFrom, NewCard cardTo, ResolvedCard resolvedCard, boolean notify) {
        resolvedCard = resolvedCard != null ? resolvedCard : new ResolvedCard(cardFrom.getBody());
        CardMovedOnBoardEvent event = new CardMovedOnBoardEvent((ContentEntityObject)abstractPage, resolvedCard, cardFrom.getContainerId(), cardTo.getContainerId(), Board.Type.LABEL, notify);
        this.eventPublisher.publish((Object)event);
    }

    private ResolvedFilter getResolvedFilter(AbstractPage abstractPage, Filter boardFilter) {
        Page parentPage = null;
        if (boardFilter != null && StringUtils.isNotBlank((CharSequence)boardFilter.getParent())) {
            try {
                parentPage = StringUtils.equalsIgnoreCase((CharSequence)"@self", (CharSequence)boardFilter.getParent()) && abstractPage instanceof Page ? (Page)abstractPage : this.pageManager.getPage(Long.parseLong(boardFilter.getParent()));
            }
            catch (NumberFormatException e) {
                parentPage = this.pageManager.getPage(StringUtils.isNotBlank((CharSequence)boardFilter.getSpaceKey()) ? boardFilter.getSpaceKey() : abstractPage.getSpaceKey(), boardFilter.getParent());
            }
        }
        return new ResolvedFilter(boardFilter, parentPage);
    }
}

