/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.boards.model;

import com.comalatech.confluence.adhoclists.model.Filter;
import com.comalatech.confluence.adhoclists.model.Table;
import com.comalatech.confluence.boards.model.Container;
import com.comalatech.confluence.boards.model.MockBoard;
import com.comalatech.confluence.boards.rest.model.UserInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="board")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Board
implements Table {
    @XmlElement(name="row")
    private List<Row> rows;
    private String name;
    @XmlElement(name="type", required=true)
    private Type type;
    private String maxRows;
    private boolean matchHeight;
    private boolean matchRowHeight;
    private String description;
    private String templateName;
    private boolean leftJustified = false;
    private boolean boardNotifications = false;
    private boolean hideDescriptions = false;
    private boolean cardsOnlyBoard = false;
    private boolean pagesOnlyBoard = false;
    private boolean noWrapCards = false;
    private boolean hideClearOption = false;
    @XmlElement(name="filter")
    private Filter filter;
    private Map<String, UserInfo> userInfoList = new HashMap<String, UserInfo>();

    public Board() {
        this.rows = new ArrayList<Row>();
    }

    public Board(String name, Type type) {
        this.name = name;
        this.type = type;
        this.rows = new ArrayList<Row>();
    }

    public Map<String, UserInfo> getUserInfoList() {
        return this.userInfoList;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = Type.parse(type);
    }

    public Row addRow() {
        Row row = new Row();
        this.rows.add(row);
        return row;
    }

    public void setRows(List<Row> rows) {
        this.rows = rows;
    }

    public List<Row> getRows() {
        return this.rows;
    }

    @XmlTransient
    public int getMaxColumns() {
        int max = 0;
        for (Row row : this.rows) {
            if (row.columns.size() <= max) continue;
            max = row.columns.size();
        }
        return max;
    }

    @XmlTransient
    public Set<String> getAllKeys() {
        HashSet<String> keys = new HashSet<String>();
        if (this.rows != null) {
            for (Row row : this.rows) {
                for (Column column : row.columns) {
                    for (Container container : column.containers) {
                        if (container.getKey() == null || keys.contains(container.getKey())) continue;
                        keys.add(container.getKey());
                    }
                }
            }
        }
        return keys;
    }

    @XmlTransient
    public boolean isLabel() {
        return this.type == Type.LABEL;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isMatchHeight() {
        return this.matchHeight;
    }

    public void setMatchHeight(boolean matchHeight) {
        this.matchHeight = matchHeight;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void clear() {
        for (Row row : this.rows) {
            for (Column column : row.getColumns()) {
                for (Container container : column.containers) {
                    container.setCards(null);
                }
            }
        }
    }

    @Override
    public MockBoard toMock() {
        MockBoard mock = new MockBoard(this.name, this.description);
        for (Row row : this.rows) {
            MockBoard.Row mockRow = new MockBoard.Row();
            for (Column column : row.getColumns()) {
                MockBoard.Column mockColumn = new MockBoard.Column();
                for (Container container : column.getContainers()) {
                    mockColumn.add(new MockBoard.Container(container.getCompositeStyle(), container.getCaption()));
                }
                mockRow.add(mockColumn);
            }
            mock.getRows().add(mockRow);
        }
        return mock;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Board board = (Board)o;
        if (this.name != null ? !this.name.equals(board.name) : board.name != null) {
            return false;
        }
        return !(this.rows != null ? !this.rows.equals(board.rows) : board.rows != null);
    }

    public String toString() {
        return "Board [rows=" + this.rows + ", name=" + this.name + ", type=" + this.type + ", matchHeight=" + this.matchHeight + "]";
    }

    public boolean isMatchRowHeight() {
        return this.matchRowHeight;
    }

    public void setMatchRowHeight(boolean matchRowHeight) {
        this.matchRowHeight = matchRowHeight;
    }

    @Override
    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public boolean isLeftJustified() {
        return this.leftJustified;
    }

    public void setLeftJustified(boolean leftJustified) {
        this.leftJustified = leftJustified;
    }

    public boolean isBoardNotifications() {
        return this.boardNotifications;
    }

    public void setBoardNotifications(boolean boardNotifications) {
        this.boardNotifications = boardNotifications;
    }

    public boolean isHideDescriptions() {
        return this.hideDescriptions;
    }

    public void setHideDescriptions(boolean hideDescriptions) {
        this.hideDescriptions = hideDescriptions;
    }

    public boolean isCardsOnlyBoard() {
        return this.cardsOnlyBoard;
    }

    public void setCardsOnlyBoard(boolean cardsOnlyBoard) {
        this.cardsOnlyBoard = cardsOnlyBoard;
    }

    public boolean isPagesOnlyBoard() {
        return this.pagesOnlyBoard;
    }

    public void setPagesOnlyBoard(boolean pagesOnlyBoard) {
        this.pagesOnlyBoard = pagesOnlyBoard;
    }

    public boolean isNoWrapCards() {
        return this.noWrapCards;
    }

    public void setNoWrapCards(boolean noWrapCards) {
        this.noWrapCards = noWrapCards;
    }

    public String getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(String maxRows) {
        this.maxRows = maxRows;
    }

    public boolean isHideClearOption() {
        return this.hideClearOption;
    }

    public void setHideClearOption(boolean hideClearOption) {
        this.hideClearOption = hideClearOption;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    @XmlType(name="type")
    @XmlEnum(value=String.class)
    public static enum Type {
        LABEL,
        PAGE,
        STATE;


        public static Type parse(String type) {
            for (Type daType : Type.values()) {
                if (!daType.toString().equalsIgnoreCase(type)) continue;
                return daType;
            }
            return LABEL;
        }
    }

    @XmlRootElement(name="row")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Row {
        private String header;
        private String footer;
        @XmlElement(name="column")
        private List<Column> columns = new ArrayList<Column>();

        public Column addColumn() {
            Column column = new Column();
            this.columns.add(column);
            return column;
        }

        public List<Column> getColumns() {
            return this.columns;
        }

        @XmlTransient
        public int getColumnWidth() {
            return 100 / this.columns.size();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Row row = (Row)o;
            return !(this.columns != null ? !this.columns.equals(row.columns) : row.columns != null);
        }

        public int hashCode() {
            return this.columns != null ? this.columns.hashCode() : 0;
        }

        public String getFooter() {
            return this.footer;
        }

        public void setFooter(String footer) {
            this.footer = footer;
        }

        public String getHeader() {
            return this.header;
        }

        public void setHeader(String header) {
            this.header = header;
        }

        public String toString() {
            return "Row [header=" + this.header + ", footer=" + this.footer + ", columns=" + this.columns + "]";
        }
    }

    @XmlRootElement(name="column")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Column {
        private String header;
        private String footer;
        @XmlElement(name="container")
        private List<Container> containers = new ArrayList<Container>();

        public void add(Container container) {
            this.containers.add(container);
        }

        public List<Container> getContainers() {
            return this.containers;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Column column = (Column)o;
            return !(this.containers != null ? !this.containers.equals(column.containers) : column.containers != null);
        }

        public int hashCode() {
            return this.containers != null ? this.containers.hashCode() : 0;
        }

        public String getHeader() {
            return this.header;
        }

        public void setHeader(String header) {
            this.header = header;
        }

        public String getFooter() {
            return this.footer;
        }

        public void setFooter(String footer) {
            this.footer = footer;
        }
    }
}

