/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.rest;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.User;
import com.comalatech.confluence.adhoclists.AdhocListsException;
import com.comalatech.confluence.adhoclists.boards.BoardValidator;
import com.comalatech.confluence.adhoclists.condition.RestCondition;
import com.comalatech.confluence.adhoclists.exceptions.InvalidLabelException;
import com.comalatech.confluence.adhoclists.filter.FilterManager;
import com.comalatech.confluence.adhoclists.model.Table;
import com.comalatech.confluence.adhoclists.rest.AdhocListsRestException;
import com.comalatech.confluence.adhoclists.rest.PermissionRequired;
import com.comalatech.confluence.adhoclists.storage.serializer.Serializer;
import com.comalatech.confluence.adhoclists.templates.AdhocTemplateManager;
import com.comalatech.confluence.adhoclists.utils.AdhocListsUtils;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRestResources<T extends Table> {
    private static final Logger log = LoggerFactory.getLogger(AbstractRestResources.class);
    protected PageManager pageManager;
    private final SpaceManager spaceManager;
    private final PermissionManager permissionManager;
    protected LabelManager labelManager;
    protected FilterManager filterManager;
    private final ContentEntityManager contentEntityManager;
    private final VelocityHelperService velocityHelperService;
    protected BoardValidator boardValidator;
    protected RestCondition restCondition;
    protected AdhocTemplateManager adhocTemplateManager;
    protected PageTemplateManager pageTemplateManager;
    protected I18nResolver i18nResolver;

    public AbstractRestResources(PageManager pageManager, SpaceManager spaceManager, PermissionManager permissionManager, LabelManager labelManager, FilterManager filterManager, ContentEntityManager contentEntityManager, AdhocTemplateManager adhocTemplateManager, PageTemplateManager pageTemplateManager, I18nResolver i18nResolver, RestCondition restCondition, BoardValidator boardValidator, VelocityHelperService velocityHelperService) {
        this.pageManager = pageManager;
        this.spaceManager = spaceManager;
        this.permissionManager = permissionManager;
        this.labelManager = labelManager;
        this.filterManager = filterManager;
        this.contentEntityManager = contentEntityManager;
        this.adhocTemplateManager = adhocTemplateManager;
        this.pageTemplateManager = pageTemplateManager;
        this.i18nResolver = i18nResolver;
        this.restCondition = restCondition;
        this.boardValidator = boardValidator;
        this.velocityHelperService = velocityHelperService;
    }

    private void checkPermissions(AbstractRestCommand command, ConfluenceEntityObject ceo) throws AdhocListsRestException {
        PermissionRequired.Type[] permissionTypes;
        Method enclosingMethod = command.getClass().getEnclosingMethod();
        if (enclosingMethod == null) {
            throw new RuntimeException("command must be anonymous class");
        }
        PermissionRequired annotation = enclosingMethod.getAnnotation(PermissionRequired.class);
        if (annotation == null) {
            throw new AdhocListsRestException(403);
        }
        for (PermissionRequired.Type type : permissionTypes = annotation.permissionTypes()) {
            if (type == PermissionRequired.Type.CREATEPAGE) {
                if (!(ceo instanceof Space) || this.permissionManager.hasCreatePermission(AuthenticatedUserThreadLocal.get(), (Object)ceo, Page.class)) continue;
                throw new AdhocListsRestException(type.getHttpErrorCode());
            }
            if (type == PermissionRequired.Type.SHOWBOARD) {
                if (this.restCondition.isBoardsVisible(ceo)) continue;
                throw new AdhocListsRestException(type.getHttpErrorCode(), type.getMessage());
            }
            if (type == PermissionRequired.Type.SHOWLIST) {
                if (this.restCondition.isListsVisible(ceo)) continue;
                throw new AdhocListsRestException(type.getHttpErrorCode(), type.getMessage());
            }
            this.checkPermission(ceo, type);
        }
    }

    protected void checkPermission(ConfluenceEntityObject ceo, PermissionRequired.Type type) throws AdhocListsRestException {
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), type.getPermission(), (Object)ceo)) {
            throw new AdhocListsRestException(type.getHttpErrorCode(), type.getMessage());
        }
    }

    public abstract Serializer<T> getSerializer();

    protected T deserializeTable(String jsonTable) throws AdhocListsException {
        T table = this.getSerializer().deserialize(jsonTable);
        if (table == null) {
            throw new AdhocListsException("could not deserialize " + jsonTable);
        }
        return table;
    }

    protected String serializeTable(T table) {
        return this.getSerializer().serialize(table);
    }

    protected List<String> getLabels(String labelsList) throws InvalidLabelException {
        if (!StringUtils.isNotBlank((CharSequence)labelsList)) {
            return Collections.emptyList();
        }
        List<Label> labelList = AdhocListsUtils.toLabelList(labelsList);
        ArrayList<String> labels = new ArrayList<String>();
        for (Label label : labelList) {
            if (LabelParser.parse((String)label.getName(), (User)AuthenticatedUserThreadLocal.get()) == null) {
                throw new InvalidLabelException("Invalid label: ", label.getName());
            }
            labels.add(label.getName());
        }
        return labels;
    }

    protected Response renderTemplate(String template, String contextParamName, Object contextParam) throws AdhocListsException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(contextParamName, contextParam);
        return this.renderTemplate(template, parameters);
    }

    protected Response renderTemplate(String template, Map<String, Object> parameters) throws AdhocListsException {
        return Response.ok((Object)this.renderTemplateHtml(template, parameters)).build();
    }

    protected String renderTemplateHtml(String template, String contextParamName, Object contextParam) throws AdhocListsException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(contextParamName, contextParam);
        return this.renderTemplateHtml(template, parameters);
    }

    protected String renderTemplateHtml(String template, Map<String, Object> parameters) throws AdhocListsException {
        Map contextMap = MacroUtils.defaultVelocityContext();
        contextMap.put("labelManager", this.labelManager);
        contextMap.putAll(parameters);
        try {
            return this.velocityHelperService.getRenderedTemplate(template, contextMap);
        }
        catch (Exception e) {
            throw new AdhocListsException(e);
        }
    }

    protected String getTemplateBody(String spaceKey, String templateName) {
        if (!StringUtils.isNotBlank((CharSequence)templateName)) {
            return null;
        }
        return this.adhocTemplateManager.getTemplateBody(spaceKey, templateName);
    }

    public abstract class TableRestCommand
    extends AbstractRestCommand {
        private String jsonTable;

        protected abstract Response doInCommand(T var1) throws AdhocListsException;

        @Override
        protected Response doInCommand() throws AdhocListsException {
            return this.doInCommand(AbstractRestResources.this.deserializeTable(this.jsonTable));
        }

        public Response execute(String jsonTable) {
            this.jsonTable = jsonTable;
            return this.execute();
        }
    }

    public abstract class SpaceRestCommand
    extends AbstractRestCommand {
        private String spaceKey;

        protected abstract Response doInCommand(Space var1) throws AdhocListsException;

        @Override
        protected Response doInCommand() throws AdhocListsException {
            return this.doInCommand(this.getSpace(this.spaceKey));
        }

        public Response execute(String spaceKey) {
            this.spaceKey = spaceKey;
            return this.execute();
        }
    }

    public abstract class PageRestCommand
    extends AbstractRestCommand {
        private long pageId;

        protected abstract Response doInCommand(AbstractPage var1) throws AdhocListsException;

        @Override
        protected Response doInCommand() throws AdhocListsException {
            return this.doInCommand(this.getPage(this.pageId));
        }

        public Response execute(long pageId) {
            this.pageId = pageId;
            return this.execute();
        }
    }

    public abstract class ContentRestCommand
    extends AbstractRestCommand {
        private long contentId;

        protected abstract Response doInCommand(ConfluenceEntityObject var1) throws AdhocListsException;

        @Override
        protected Response doInCommand() throws AdhocListsException {
            return this.doInCommand(this.getContent(this.contentId));
        }

        public Response execute(long contentId) {
            this.contentId = contentId;
            return this.execute();
        }
    }

    public abstract class AbstractRestCommand {
        protected AbstractPage getPage(long pageId) throws AdhocListsException {
            AbstractPage page = AbstractRestResources.this.pageManager.getAbstractPage(pageId);
            if (page == null) {
                throw new AdhocListsRestException(400);
            }
            AbstractRestResources.this.checkPermissions(this, (ConfluenceEntityObject)page);
            return page;
        }

        protected AbstractPage getNullablePage(long pageId) throws AdhocListsException {
            if (pageId > 0L) {
                return this.getPage(pageId);
            }
            return null;
        }

        protected Page getNullablePage(String spaceKey, String title) throws AdhocListsException {
            return AbstractRestResources.this.pageManager.getPage(spaceKey, title);
        }

        protected ConfluenceEntityObject getContent(long contentId) throws AdhocListsException {
            if (contentId == 0L) {
                String errorResponse = AbstractRestResources.this.renderTemplateHtml("/templates/adhoclists/vm/boards/rte/editboarderror.vm", new HashMap<String, Object>());
                throw new AdhocListsRestException(400, errorResponse);
            }
            ContentEntityObject ceo = AbstractRestResources.this.contentEntityManager.getById(contentId);
            if (ceo == null) {
                ceo = AbstractRestResources.this.pageTemplateManager.getPageTemplate(contentId);
            }
            if (ceo == null) {
                throw new AdhocListsRestException(400, AbstractRestResources.this.i18nResolver.getText("adhoccanvas.rest.error.invalid.contentId", new Serializable[]{Long.valueOf(contentId)}));
            }
            AbstractRestResources.this.checkPermissions(this, (ConfluenceEntityObject)ceo);
            return ceo;
        }

        protected String getSpaceKey(ConfluenceEntityObject ceo) {
            if (ceo instanceof AbstractPage) {
                return ((AbstractPage)ceo).getSpaceKey();
            }
            if (ceo instanceof Draft) {
                return ((Draft)ceo).getDraftSpaceKey();
            }
            if (ceo instanceof PageTemplate) {
                Space space = ((PageTemplate)ceo).getSpace();
                if (space != null) {
                    return space.getKey();
                }
                return null;
            }
            return null;
        }

        protected Space getSpace(String spaceKey) throws AdhocListsException {
            Space space = AbstractRestResources.this.spaceManager.getSpace(spaceKey);
            if (space == null) {
                throw new AdhocListsRestException(400);
            }
            AbstractRestResources.this.checkPermissions(this, (ConfluenceEntityObject)space);
            return space;
        }

        protected abstract Response doInCommand() throws AdhocListsException;

        protected Response execute() {
            try {
                return this.doInCommand();
            }
            catch (InvalidLabelException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
            }
            catch (AdhocListsRestException e) {
                return Response.status((int)e.getStatus()).entity((Object)e.getMessage()).build();
            }
            catch (AdhocListsException e) {
                log.error(e.getMessage());
                return Response.noContent().build();
            }
            catch (Error error) {
                log.error("", (Throwable)error);
                return Response.serverError().build();
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
                return Response.serverError().build();
            }
        }
    }
}

