/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.mywork;

import com.atlassian.mywork.service.NotificationService;
import com.comalatech.confluence.adhoclists.AdhocListsException;
import com.comalatech.confluence.adhoclists.mywork.NotificationServiceAccessor;
import com.comalatech.confluence.adhoclists.mywork.NotificationServiceFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class NotificationServiceAccessorImpl
implements NotificationServiceAccessor {
    private final ApplicationContext applicationContext;
    private NotificationService notificationService;

    public NotificationServiceAccessorImpl(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public NotificationService getNotificationService() throws ClassNotFoundException, AdhocListsException {
        if (this.notificationService == null) {
            this.notificationService = this.initNotificationService();
            if (this.notificationService == null) {
                throw new NullPointerException("notificationService");
            }
            return this.notificationService;
        }
        return this.notificationService;
    }

    private NotificationService initNotificationService() throws ClassNotFoundException, AdhocListsException {
        Class<?> notificationServiceFactoryClass = this.getNotificationServiceFactoryClass();
        if (notificationServiceFactoryClass != null) {
            return ((NotificationServiceFactory)this.applicationContext.getAutowireCapableBeanFactory().createBean(notificationServiceFactoryClass, 3, false)).get();
        }
        throw new AdhocListsException("cannot create mywork notification service");
    }

    private Class<?> getNotificationServiceFactoryClass() throws ClassNotFoundException {
        this.getClass().getClassLoader().loadClass("com.atlassian.mywork.service.NotificationService");
        return this.getClass().getClassLoader().loadClass("com.comalatech.confluence.adhoclists.mywork.NotificationServiceFactory");
    }
}

