/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.model;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.labels.ParsedLabelName;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.user.User;
import com.comalatech.confluence.adhoclists.model.Filter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ResolvedFilter
extends Filter {
    private List<Label> labelsList;
    private Page parentPage;

    public ResolvedFilter() {
        this.labelsList = new ArrayList<Label>();
    }

    public ResolvedFilter(List<String> labels, Page parent) {
        super(labels);
        this.parentPage = parent;
        this.setLabelsList(labels);
    }

    public ResolvedFilter(Filter filter) {
        this.setLabels(filter.getLabels());
        this.setParent(filter.getParent());
        this.setDepth(filter.getDepth());
        this.setSpaceKey(filter.getSpaceKey());
        this.setLabelsList(filter.getLabels());
        this.setAllSpaces(filter.isAllSpaces());
    }

    public ResolvedFilter(Filter filter, Page parentPage) {
        this.setLabels(filter.getLabels());
        this.setParent(filter.getParent());
        this.setDepth(filter.getDepth());
        this.setSpaceKey(filter.getSpaceKey());
        this.setLabelsList(filter.getLabels());
        this.setAllSpaces(filter.isAllSpaces());
        this.setParentPage(parentPage);
    }

    public void setLabelsList(List<String> labels) {
        this.setLabels(labels);
        this.labelsList = new ArrayList<Label>(labels.size());
        for (String labelName : labels) {
            ParsedLabelName parsedLabel = LabelParser.parse((String)labelName, (User)AuthenticatedUserThreadLocal.get());
            if (parsedLabel == null) continue;
            this.labelsList.add(parsedLabel.toLabel());
        }
    }

    public boolean containsLabels(AbstractPage abstractPage) {
        if (this.getLabels().isEmpty()) {
            return true;
        }
        List pageLabels = abstractPage.getLabels();
        return new HashSet(pageLabels).containsAll(this.labelsList);
    }

    public void setParentPage(Page parentPage) {
        this.parentPage = parentPage;
    }

    public List<Label> getLabelsList() {
        return this.labelsList;
    }

    public Page getParentPage() {
        return this.parentPage;
    }
}

