/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.model;

import com.atlassian.confluence.search.v2.query.LabelQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@XmlRootElement(name="filter")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Filter {
    public static final String SELF = "@self";
    protected int depth = 0;
    protected String spaceKey;
    private List<String> labels = new ArrayList<String>();
    private String parent;
    private boolean allSpaces = false;

    public Filter() {
    }

    public Filter(List<String> labels) {
        this();
        this.labels = labels;
    }

    public List<String> getLabels() {
        if (this.labels == null) {
            this.labels = Collections.emptyList();
        }
        return this.labels;
    }

    public String getLabelsAsCommaSeparatedString() {
        if (this.labels == null || this.labels.size() == 0) {
            return "";
        }
        return this.labels.stream().collect(Collectors.joining(","));
    }

    @XmlTransient
    public Set<LabelQuery> getLabelsQueries() {
        HashSet<LabelQuery> queries = new HashSet<LabelQuery>();
        for (String label : this.getLabels()) {
            queries.add(new LabelQuery(label));
        }
        return queries;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public boolean isChildPagesOnly() {
        return SELF.equalsIgnoreCase(this.parent);
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public boolean isAllSpaces() {
        return this.allSpaces;
    }

    public void setAllSpaces(boolean allSpaces) {
        this.allSpaces = allSpaces;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SIMPLE_STYLE);
    }
}

