/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.metadata;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.adhoclists.metadata.MetadataAccessor;
import com.comalatech.confluence.adhoclists.metadata.MetadataManagerAccessor;
import com.servicerocket.confluence.randombits.metadata.MetadataManager;
import com.servicerocket.confluence.randombits.metadata.MetadataStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomwareMetaDataAccessor
implements MetadataAccessor {
    private static final Logger log = LoggerFactory.getLogger(CustomwareMetaDataAccessor.class);
    private final MetadataManagerAccessor metadataManagerAccessor;

    CustomwareMetaDataAccessor(MetadataManagerAccessor metadataManagerAccessor) {
        this.metadataManagerAccessor = metadataManagerAccessor;
    }

    public MetadataStorage getStorage(AbstractPage page) {
        return this.getInstance().loadWritableData((ContentEntityObject)page);
    }

    @Override
    public String getValue(AbstractPage page, String valueName) {
        MetadataStorage data = this.getStorage(page);
        return data.getString(valueName, "");
    }

    @Override
    public void setValue(AbstractPage page, String valueName, String value) {
        MetadataStorage data = this.getStorage(page);
        data.setString(valueName, value);
        this.getInstance().saveData(data, true);
    }

    private MetadataManager getInstance() {
        try {
            return (MetadataManager)this.metadataManagerAccessor.getMetadataManager().getMetadataManager();
        }
        catch (Exception e) {
            log.error("Error getting MetadataManager", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }
}

