/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.lists.model;

import com.comalatech.confluence.adhoclists.lists.model.ChecklistColumn;
import com.comalatech.confluence.adhoclists.lists.model.ValueType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public abstract class Column<T extends ValueType> {
    private String header;
    private String width;
    private String style;
    private boolean readOnly;
    private transient String key;

    public Column() {
        XmlRootElement annotation = this.getClass().getAnnotation(XmlRootElement.class);
        this.key = annotation == null ? "column" : annotation.name();
    }

    public Column(String header) {
        this();
        if (header == null) {
            return;
        }
        this.header = header;
    }

    protected Column(String header, String width, String style, boolean readOnly) {
        this(header);
        this.width = width;
        this.style = style;
        this.readOnly = readOnly;
    }

    public abstract T getValueType();

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public boolean isReadOnly() {
        ChecklistColumn annotation = this.getClass().getAnnotation(ChecklistColumn.class);
        return annotation != null && annotation.readOnly() || this.readOnly;
    }

    @XmlTransient
    public boolean isInputColumn() {
        ChecklistColumn annotation = this.getClass().getAnnotation(ChecklistColumn.class);
        return annotation == null || !annotation.readOnly();
    }

    @XmlTransient
    public String getHeaderDescriptionKey() {
        ChecklistColumn annotation = this.getClass().getAnnotation(ChecklistColumn.class);
        if (annotation == null || annotation.headerHintKey() == null || annotation.headerHintKey().length() == 0) {
            return null;
        }
        return annotation.headerHintKey();
    }

    public boolean hasDetails() {
        return StringUtils.isNotBlank((CharSequence)this.width) || StringUtils.isNotBlank((CharSequence)this.style) || this.isInputColumn() && this.readOnly;
    }

    public String getKey() {
        return this.key;
    }

    public static String getTypeStatic(Class columnClass) {
        XmlRootElement annotation = columnClass.getAnnotation(XmlRootElement.class);
        if (annotation == null) {
            return "column";
        }
        return annotation.name();
    }

    public String getType() {
        return Column.getTypeStatic(this.getClass());
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Column column = (Column)o;
        if (this.readOnly != column.readOnly) {
            return false;
        }
        if (this.header != null ? !this.header.equals(column.header) : column.header != null) {
            return false;
        }
        if (this.style != null ? !this.style.equals(column.style) : column.style != null) {
            return false;
        }
        return !(this.width != null ? !this.width.equals(column.width) : column.width != null);
    }

    public int hashCode() {
        int result = this.header != null ? this.header.hashCode() : 0;
        result = 31 * result + (this.width != null ? this.width.hashCode() : 0);
        result = 31 * result + (this.style != null ? this.style.hashCode() : 0);
        result = 31 * result + (this.readOnly ? 1 : 0);
        return result;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

