/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.lists.model;

import com.comalatech.confluence.adhoclists.lists.model.Column;
import com.comalatech.confluence.adhoclists.lists.model.PageValueType;
import com.comalatech.confluence.adhoclists.lists.types.InputColumn;
import com.comalatech.confluence.adhoclists.lists.types.LabelColumn;
import com.comalatech.confluence.adhoclists.lists.types.MetadataColumn;
import com.comalatech.confluence.adhoclists.lists.types.PageColumn;
import com.comalatech.confluence.adhoclists.lists.types.SelectLabelColumn;
import com.comalatech.confluence.adhoclists.lists.types.SelectValueColumn;
import com.comalatech.confluence.adhoclists.lists.types.TaskColumn;
import com.comalatech.confluence.adhoclists.lists.types.WikiColumn;
import com.comalatech.confluence.adhoclists.lists.types.WikiInputColumn;
import com.comalatech.confluence.adhoclists.model.SortAware;
import com.comalatech.confluence.adhoclists.model.SortType;
import com.comalatech.confluence.adhoclists.model.Table;
import com.comalatech.confluence.adhoclists.utils.AdhocListsUtils;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@XmlRootElement(name="checklist")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Checklist
implements Table,
SortAware {
    private String name;
    private String description;
    private transient String id;
    private String style;
    private boolean leftJustified = false;
    @Deprecated
    private boolean useLucene = false;
    private String maxRows;
    private String templateName;
    private SortType sortType;
    private List<String> rows;
    @XmlElements(value={@XmlElement(name="label", type=LabelColumn.class), @XmlElement(name="page", type=PageColumn.class), @XmlElement(name="input", type=InputColumn.class), @XmlElement(name="wikiinput", type=WikiInputColumn.class), @XmlElement(name="selectlabel", type=SelectLabelColumn.class), @XmlElement(name="select", type=SelectValueColumn.class), @XmlElement(name="wiki", type=WikiColumn.class), @XmlElement(name="metadata", type=MetadataColumn.class), @XmlElement(name="task", type=TaskColumn.class)})
    private List<Column> columns = new ArrayList<Column>();

    public Checklist() {
    }

    public Checklist(String name) {
        this();
        this.name = name;
    }

    public void addColumn(Column column) {
        this.columns.add(column);
    }

    @Override
    public SortType getSortType() {
        return this.sortType;
    }

    @Override
    public void setSortType(SortType sortType) {
        this.sortType = sortType;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyle() {
        return this.style;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.id = AdhocListsUtils.makeId(name);
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(String maxRows) {
        this.maxRows = maxRows;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public boolean canAddRows() {
        boolean hasPageViewOrEditLinkColumn = false;
        for (Column column : this.columns) {
            PageColumn pageColumn;
            PageValueType.Type columnType;
            if (!(column instanceof PageColumn) || (columnType = (pageColumn = (PageColumn)column).getValueType().getType()) != PageValueType.Type.VIEWLINK && columnType != PageValueType.Type.EDITLINK) continue;
            if (hasPageViewOrEditLinkColumn) {
                return false;
            }
            hasPageViewOrEditLinkColumn = true;
        }
        return hasPageViewOrEditLinkColumn;
    }

    @Override
    public void clear() {
        if (this.rows != null) {
            this.rows.clear();
        }
    }

    @Override
    public Table toMock() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Checklist checklist = (Checklist)o;
        if (this.leftJustified != checklist.leftJustified) {
            return false;
        }
        if (this.useLucene != checklist.useLucene) {
            return false;
        }
        if (this.columns != null ? !this.columns.equals(checklist.columns) : checklist.columns != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(checklist.description) : checklist.description != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(checklist.id) : checklist.id != null) {
            return false;
        }
        if (this.maxRows != null ? !this.maxRows.equals(checklist.maxRows) : checklist.maxRows != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(checklist.name) : checklist.name != null) {
            return false;
        }
        if (this.rows != null ? !this.rows.equals(checklist.rows) : checklist.rows != null) {
            return false;
        }
        if (this.sortType != null ? !this.sortType.equals(checklist.sortType) : checklist.sortType != null) {
            return false;
        }
        if (this.style != null ? !this.style.equals(checklist.style) : checklist.style != null) {
            return false;
        }
        return !(this.templateName != null ? !this.templateName.equals(checklist.templateName) : checklist.templateName != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.style != null ? this.style.hashCode() : 0);
        result = 31 * result + (this.leftJustified ? 1 : 0);
        result = 31 * result + (this.useLucene ? 1 : 0);
        result = 31 * result + (this.maxRows != null ? this.maxRows.hashCode() : 0);
        result = 31 * result + (this.templateName != null ? this.templateName.hashCode() : 0);
        result = 31 * result + (this.sortType != null ? this.sortType.hashCode() : 0);
        result = 31 * result + (this.rows != null ? this.rows.hashCode() : 0);
        result = 31 * result + (this.columns != null ? this.columns.hashCode() : 0);
        return result;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @Override
    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public boolean isLeftJustified() {
        return this.leftJustified;
    }

    public void setLeftJustified(boolean leftJustified) {
        this.leftJustified = leftJustified;
    }

    @Deprecated
    public boolean isUseLucene() {
        return this.useLucene;
    }

    @Deprecated
    public void setUseLucene(boolean useLucene) {
        this.useLucene = useLucene;
    }

    public List<String> getRows() {
        return this.rows;
    }

    public void setRows(List<String> rows) {
        this.rows = rows;
    }
}

