/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.listeners;

import com.atlassian.applinks.host.spi.HostApplication;
import com.atlassian.confluence.event.events.security.LoginEvent;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.mywork.model.Notification;
import com.atlassian.mywork.model.NotificationBuilder;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.comalatech.confluence.adhoclists.boards.notification.AdhocCanvasNotificationService;
import com.comalatech.confluence.adhoclists.welcome.WelcomeManager;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class WelcomeOnLoginListener
implements DisposableBean {
    private final EventPublisher eventPublisher;
    private final WelcomeManager welcomeManager;
    private final GlobalSettingsManager settingsManager;
    private final I18nResolver i18nResolver;
    private final HostApplication hostApplication;
    private final UserAccessor userAccessor;
    private final AdhocCanvasNotificationService notificationService;

    public WelcomeOnLoginListener(@ComponentImport EventPublisher eventPublisher, WelcomeManager welcomeManager, @ComponentImport @Qualifier(value="globalSettingsManager") GlobalSettingsManager settingsManager, @ComponentImport I18nResolver i18nResolver, @Qualifier(value="hostApplication") @ComponentImport HostApplication hostApplication, @ComponentImport UserAccessor userAccessor, AdhocCanvasNotificationService notificationService) {
        this.eventPublisher = eventPublisher;
        this.welcomeManager = welcomeManager;
        this.settingsManager = settingsManager;
        this.i18nResolver = i18nResolver;
        this.hostApplication = hostApplication;
        this.userAccessor = userAccessor;
        this.notificationService = notificationService;
        eventPublisher.register((Object)this);
    }

    @EventListener
    public void userLoggedIn(LoginEvent event) {
        ConfluenceUser user = this.userAccessor.getUserByName(event.getUsername());
        if (user != null && this.welcomeManager.isShowWelcome(user)) {
            Notification notification = this.buildNotification();
            this.notificationService.sendNotifications(Map.of(user, notification));
            this.welcomeManager.setHideWelcome(user);
        }
    }

    private Notification buildNotification() {
        String itemIconUrl = this.settingsManager.getGlobalSettings().getBaseUrl() + "/download/resources/com.comalatech.adhoccanvas:boardresources/images/comalacanvas16.png";
        return new NotificationBuilder().application("com.comalatech.adhoccanvas.mywork").title(this.i18nResolver.getText("adhoccanvas.welcome.title")).itemTitle(this.i18nResolver.getText("adhoccanvas.welcome.title")).itemUrl(this.welcomeManager.getWelcomeUrl()).itemIconUrl(itemIconUrl).description(this.i18nResolver.getText("adhoccanvas.welcome.desc", new Serializable[]{this.welcomeManager.getWelcomeUrl()})).entity("canvas").action("welcome").globalId("appId=" + this.hostApplication.getId().get() + "entity=canvas&id=" + new Date().getTime()).applicationLinkId(this.hostApplication.getId().get()).createNotification();
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }
}

