/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.boards.view.model;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.adhoclists.cards.model.ResolvedCard;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="card")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RenderedCard
extends ResolvedCard {
    private boolean readOnly;
    private boolean visible;
    @XmlElement(name="contentEntityObject")
    private Content confluenceEntity;
    @XmlTransient
    private ContentEntityObject contentEntityObject;
    private String bodyHtml;
    private String contentHtml;
    private String elementId;

    public RenderedCard() {
    }

    public RenderedCard(String id, String title, String url) {
        super(id, title, url);
        this.elementId = "cardid-" + id;
        this.visible = true;
    }

    public RenderedCard(ResolvedCard card) {
        super(card);
        this.elementId = "cardid-" + Integer.toHexString(card.hashCode());
        this.visible = true;
    }

    public RenderedCard(AbstractPage page, boolean visible) {
        this(page.getIdAsString(), page.getTitle(), page.getUrlPath());
        this.contentEntityObject = page;
        this.visible = visible;
    }

    public RenderedCard(AbstractPage page) {
        this(page, true);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isVisible() {
        return this.visible;
    }

    protected void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof RenderedCard) {
            RenderedCard other = (RenderedCard)o;
            return this.getId().equals(other.getId()) && this.getTitle().equals(other.getTitle()) && this.getUrl().equals(other.getUrl()) && this.readOnly == other.readOnly;
        }
        return false;
    }

    public ContentEntityObject getContentEntityObject() {
        return this.contentEntityObject;
    }

    protected void setContentEntityObject(ContentEntityObject contentEntityObject) {
        this.contentEntityObject = contentEntityObject;
    }

    public String getBodyHtml() {
        return this.bodyHtml;
    }

    public void setBodyHtml(String bodyHtml) {
        if (bodyHtml != null && !this.cleanHtml(bodyHtml).equals(this.getBody())) {
            this.bodyHtml = bodyHtml;
        }
    }

    public String getElementId() {
        return this.elementId;
    }

    protected void setElementId(String elementId) {
        this.elementId = elementId;
    }

    public Content getConfluenceEntity() {
        return this.confluenceEntity;
    }

    public void setConfluenceEntity(Content confluenceEntity) {
        this.confluenceEntity = confluenceEntity;
    }

    public String getContentHtml() {
        return this.contentHtml;
    }

    public void setContentHtml(String contentHtml) {
        if (!this.cleanHtml(contentHtml).equals(this.getContent())) {
            this.contentHtml = contentHtml;
        }
    }

    protected String cleanHtml(String text) {
        if (text != null && text.indexOf("<p>") == 0) {
            return text.substring(3, text.length() - 4);
        }
        return text;
    }

    public static class Content {
        private Long id;
        private String title;

        public Long getId() {
            return this.id;
        }

        public String getTitle() {
            return this.title;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Content)) {
                return false;
            }
            Content other = (Content)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$id = this.getId();
            Long other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            return !(this$title == null ? other$title != null : !this$title.equals(other$title));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Content;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            return result;
        }

        public String toString() {
            return "RenderedCard.Content(id=" + this.getId() + ", title=" + this.getTitle() + ")";
        }
    }
}

