/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.boards.view;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.util.profiling.UtilTimerStack;
import com.comalatech.confluence.adhoclists.boards.view.BoardResolver;
import com.comalatech.confluence.adhoclists.boards.view.model.ResolvedBoard;
import com.comalatech.confluence.adhoclists.model.ResolvedFilter;
import com.comalatech.confluence.boards.model.Board;
import com.comalatech.confluence.boards.model.BoardViewContext;
import com.comalatech.confluence.boards.model.Container;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBoardResolver
implements BoardResolver {
    private static final Logger log = LoggerFactory.getLogger(AbstractBoardResolver.class);
    protected PermissionManager permissionManager;
    protected WikiStyleRenderer wikiStyleRenderer;

    public AbstractBoardResolver(PermissionManager permissionManager, WikiStyleRenderer wikiStyleRenderer) {
        this.permissionManager = permissionManager;
        this.wikiStyleRenderer = wikiStyleRenderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResolvedBoard resolveBoard(BoardViewContext viewContext, ResolvedFilter filter, Board board) {
        UtilTimerStack.push((String)"AbstractBoardResolver.resolveBoard()");
        try {
            ResolvedBoard resolvedBoard = new ResolvedBoard(board);
            if (board.getRows() != null) {
                for (Board.Row row : board.getRows()) {
                    ResolvedBoard.Row resolvedRow = resolvedBoard.addRow(row.getHeader(), row.getFooter());
                    for (Board.Column column : row.getColumns()) {
                        ResolvedBoard.Column resolvedColumn = resolvedRow.addColumn(column.getHeader(), column.getFooter());
                        for (Container container : column.getContainers()) {
                            resolvedColumn.add(this.getExpandedContainer(viewContext, filter, container, 0));
                        }
                    }
                }
            }
            resolvedBoard.setMoveCaptions();
            ResolvedBoard resolvedBoard2 = resolvedBoard;
            return resolvedBoard2;
        }
        finally {
            UtilTimerStack.pop((String)"AbstractBoardResolver.resolveBoard()");
        }
    }

    protected boolean canView(ConfluenceUser user, ContentEntityObject ceo) {
        return this.permissionManager.hasPermission(user, Permission.VIEW, (Object)ceo);
    }

    protected boolean isAdmin(ConfluenceUser user) {
        return this.permissionManager.isConfluenceAdministrator(user);
    }

    protected String renderDescription(String description) {
        if (!StringUtils.isNotBlank((CharSequence)description)) {
            return null;
        }
        try {
            return this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)new Page().toPageContext(), description);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return description;
        }
    }
}

