/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.boards.notification;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.mywork.model.Notification;
import com.atlassian.mywork.service.NotificationService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.adhoclists.AdhocListsException;
import com.comalatech.confluence.adhoclists.boards.events.WatcherNotificationSentEvent;
import com.comalatech.confluence.adhoclists.boards.notification.AdhocCanvasNotificationService;
import com.comalatech.confluence.adhoclists.mywork.NotificationServiceAccessor;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultAdhocCanvasNotificationService
implements AdhocCanvasNotificationService {
    private static final Logger log = LoggerFactory.getLogger(DefaultAdhocCanvasNotificationService.class);
    private final NotificationServiceAccessor notificationServiceAccessor;
    private final EventPublisher eventPublisher;

    public DefaultAdhocCanvasNotificationService(NotificationServiceAccessor notificationServiceAccessor, @ComponentImport EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        this.notificationServiceAccessor = notificationServiceAccessor;
    }

    @Override
    public void sendNotifications(Map<ConfluenceUser, Notification> notifications) {
        try {
            NotificationService service = this.notificationServiceAccessor.getNotificationService();
            for (ConfluenceUser user : notifications.keySet()) {
                log.debug("sending mywork notification to " + user.getName());
                service.createOrUpdate(user.getName(), notifications.get(user));
            }
            this.eventPublisher.publish((Object)new WatcherNotificationSentEvent());
        }
        catch (AdhocListsException | ClassNotFoundException e) {
            log.error("cant find mywork notification service");
        }
    }
}

