/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var AUI = AUI || {};

/**
 * Backbone view hierarchy to match AUIs Dialog layout as per https://developer.atlassian.com/display/AUI/Dialog
 * Note that it does not pops up, its just the dialog
 */


/**
 * Must be inside <div class="aui-dialog">
 * @type {*}
 */

AUI.DialogComponents = Backbone.View.extend({

    className: "dialog-components",
    title: "Dialog Title",


    initialize: function() {
        this.title = this.options.title || this.title;
    },

    render: function() {
        if (! this.options.hideTitle) {
            this.$el.append(this.make("h2",{"class": "dialog-title"},this.title));
        }
        return this;
    }
});

AUI.PageMenuSeparator = Backbone.View.extend({
    tagName: "li",
    className: "page-menu-separator",

    render: function() {
        this.$el.html(this.make("h3",{},this.options.caption));
        return this;
    }

});


AUI.PageMenuItem = Backbone.View.extend({
    tagName: "li",
    className: "page-menu-item",
    loading: true,  // Loading icon appears when clicked at button. set false to no show icon
    
    events: {
        "click button" : "clickSelect"
    },

    initialize: function() {
        this.$el.attr("target",this.options.target);
        if (this.options.select) {
            this.select = this.options.select;
        }
        if (typeof this.options.loading !== 'undefined') {
            this.loading = this.options.loading;
        }
    },

    clickSelect: function() {
        var loading = "";
        if(this.loading) {
            loading = "loading";
        }
        AJS.$(".page-menu-item").removeClass("selected " + loading);
        this.$el.addClass("selected " + loading);
        this.select();
    },

    select: function() {
        var target = this.$el.attr("target");
        AUI.DialogPanels.selectPanel(AJS.$("#" + target),this);
    },

    render: function() {
        this.$el.html(this.make("button",{
            "class": "item-button"
        },this.options.caption));
        return this;
    }
});

AUI.PageMenu = Backbone.View.extend({
    tagName: "ul",
    className: "dialog-page-menu",

    initialize: function(height) {
        this.$el.css({height: height + "px"});
    },

    render: function() {
        return this;
    }
});

AUI.DialogPanels = Backbone.View.extend({
    className: "dialog-page-body",

    initialize: function(height) {
        this.$el.css({height: height + "px"});
    },

    render: function() {
        return this;
    }
},{

    addPanel: function($panel) {
        AJS.$(".dialog-page-body").append($panel);
    },

    selectPanel: function($panel,$menuItem) {
        AJS.$(".dialog-panel-body").addClass("hidden");
        $panel.removeClass("hidden").trigger("panel.select",$menuItem);
    }
});

AUI.DialogButtonPanel = Backbone.View.extend({
    className: "dialog-button-panel"
});

