/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

(function ($) {

    var showTips = function() {
        AJS.$(".cnv-tipable.cnv-first").tooltip({gravity: 'nw', delayIn: 1000, trigger: 'manual'});
        AJS.$(".cnv-tipable.cnv-second").tooltip({gravity: 'nw',delayIn: 1000, trigger: 'manual'});
        setTimeout(function() {
            AJS.$(".cnv-tipable.cnv-first").tooltip("show");
            setTimeout(function() {
                AJS.$(".cnv-tipable.cnv-first").tooltip("hide");
                AJS.$(function() {
                    AJS.$(".cnv-tipable.cnv-second").tooltip("show");
                    setTimeout(function() {
                        AJS.$(".cnv-tipable.cnv-second").tooltip("hide");
                    },2000);
                },500);
            },2000);
        },1000);

        // hide tooltips when rte (edit mode)
        AJS.$('#editPageLink').click(function() {
            AJS.$(".cnv-tipable.cnv-first").tooltip("hide");
            AJS.$(".cnv-tipable.cnv-second").tooltip("hide");
        })
    };


    AJS.toInit(function ($) {
        AJS.$(".cnv-tipable").tooltip({gravity: 'nw', delayIn: 1000});
        var views = Canvas.CML.Cookies.read("com.comalatech.canvas.views");
        if (views) {
            if (views < 5) {
                showTips();
                Canvas.CML.Cookies.create("com.comalatech.canvas.views",+views + 1,1000);
            }
        } else {
            showTips();
            Canvas.CML.Cookies.create("com.comalatech.canvas.views","1",1000);
        }
        AJS.$(".containerheading .cnv-tipable").each( function(index, el){
            var description = $(el).text();
            var $heading = $(el).parent(".containerheading");
            $heading.attr("title", description);
            $heading.tooltip({gravity: 'nw', delayIn: 1000});

       });
    });
})(AJS.$);
