/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

(function ($) {
    if (Canvas.initialized("select.cell")) {
        return;
    }

    AJS.toInit(function ($) {
        AJS.log("init select.cell");
        $(document).on('change', ".adhocchecklist.view select.select", function() {
            var $selected = $(this).find("option:selected");
            var $cell = $(this).parents("td.cell-select");
            var pageId = Adhoc.Checklist.rowId($cell);
            var valueName = $("input[name='valuename']", $cell).val();
            if (! Adhoc.Checklist.empty($cell)) {
                $.ajax({
                    type: "POST",
                    cache: false,
                    data:  $selected.val(),
                    contentType: "application/json; charset=utf-8",
                    url: AJS.Confluence.getContextPath() + "/rest/adhoclists/latest/lists/metadata/" +
                            pageId +
                            "/set?valueName=" + encodeURIComponent(valueName),
                    success: function (action, textStatus, jqXHR) {
                        $("span.sortvalue",$cell).html($selected.html());
                        $(".adhocchecklist.view").trigger("update");
                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        Adhoc.common.errorHandler($cell.parents("tr.page"),jqXHR, textStatus,errorThrown);
                    }
                });
            }
        });
        $(document).on('resetcell', "tr.newpagerow td.cell-select", function(event) {
            $("select option",$(this)).each(function() {
                $(this).removeAttr("selected");
            });
        });
        $(document).on('initcell', "tr.newpagerow td.cell-select", function(event,$newrow) {
            var $cell = $(this);
            var $newCell = $("td:nth-child(" + $cell.attr("index") + ")",$newrow);
            var selected = $("option:selected",$cell).val();
            if (selected && selected.length > 0) {
                $("option[value='" + selected + "']",$newCell).prop("selected","selected");
                $("select.select",$newCell).change();
            }
        });
    });
})(AJS.$);
