/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.rest;

import com.atlassian.confluence.security.Permission;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
public @interface PermissionRequired {
    public Type[] permissionTypes() default {};

    public static enum Type {
        VIEW(Permission.VIEW, 404, "No permission to view content"),
        EDIT(Permission.EDIT, 403, "No permission to edit content"),
        CREATEPAGE(null, 403, "No permission to create content"),
        SHOWBOARD(null, 403, "Adhoc Boards are not enabled in this space"),
        SHOWLIST(null, 403, "Adhoc Lists are not enabled in this space");

        private final Permission permission;
        private final int httpErrorCode;
        private final String message;

        private Type(Permission permission, int httpErrorCode, String message) {
            this.permission = permission;
            this.httpErrorCode = httpErrorCode;
            this.message = message;
        }

        public Permission getPermission() {
            return this.permission;
        }

        public int getHttpErrorCode() {
            return this.httpErrorCode;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

