/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.mywork;

import com.atlassian.mywork.service.NotificationService;
import com.comalatech.confluence.adhoclists.AdhocListsException;
import com.comalatech.confluence.adhoclists.mywork.NotificationServiceAccessor;
import com.comalatech.confluence.adhoclists.mywork.NotificationServiceFactory;
import com.google.common.base.Preconditions;
import org.springframework.context.ApplicationContext;

public class NotificationServiceAccessorImpl
implements NotificationServiceAccessor {
    private final ApplicationContext applicationContext;
    private NotificationService notificationService;

    public NotificationServiceAccessorImpl(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public NotificationService getNotificationService() throws ClassNotFoundException, AdhocListsException {
        if (this.notificationService == null) {
            this.notificationService = (NotificationService)Preconditions.checkNotNull((Object)this.initNotificationService(), (Object)"notificationService");
        }
        return this.notificationService;
    }

    private NotificationService initNotificationService() throws ClassNotFoundException, AdhocListsException {
        Class<?> notificationServiceFactoryClass = this.getNotificationServiceFactoryClass();
        if (notificationServiceFactoryClass != null) {
            NotificationService notificationService = ((NotificationServiceFactory)this.applicationContext.getAutowireCapableBeanFactory().createBean(notificationServiceFactoryClass, 3, false)).get();
            return notificationService;
        }
        throw new AdhocListsException("cannot create mywork notification service");
    }

    private Class<?> getNotificationServiceFactoryClass() throws ClassNotFoundException {
        this.getClass().getClassLoader().loadClass("com.atlassian.mywork.service.NotificationService");
        return this.getClass().getClassLoader().loadClass("com.comalatech.confluence.adhoclists.mywork.NotificationServiceFactory");
    }
}

