/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.license;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.extras.api.LicenseType;
import com.atlassian.license.License;
import com.atlassian.license.LicenseManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.comalatech.confluence.adhoclists.license.AdhocLicenseManager;
import java.net.URI;
import java.util.Date;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAdhocLicenseManager
implements AdhocLicenseManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultAdhocLicenseManager.class);
    public static long ABOUT_TO_EXPIRE_OFFSET_MS = 432000000L;
    private int CACHE_TTL_MS = 3600000;
    protected final PluginLicenseManager licenseManager;
    private final ApplicationProperties applicationProperties;
    private final PluginAccessor pluginAccessor;
    private final boolean developmentInstance;
    private CachedLicenseStatus cachedLicenseStatus = null;

    public DefaultAdhocLicenseManager(PluginLicenseManager licenseManager, ApplicationProperties applicationProperties, PluginAccessor pluginAccessor) {
        this.licenseManager = licenseManager;
        this.applicationProperties = applicationProperties;
        this.pluginAccessor = pluginAccessor;
        this.developmentInstance = this.checkDevelopmentMode();
    }

    @Override
    public boolean isDevelopmentInstance() {
        return this.developmentInstance;
    }

    private boolean checkDevelopmentMode() {
        boolean isDevelopmentMode = false;
        boolean isAtlassianDevMode = Boolean.parseBoolean(System.getProperty("atlassian.dev.mode", "false"));
        boolean isComalatechDevMode = Boolean.parseBoolean(System.getProperty("comalatech.dev", "false"));
        boolean isConfluenceDevLicence = this.checkConfluenceDevLicence();
        if (isAtlassianDevMode && isComalatechDevMode && isConfluenceDevLicence) {
            isDevelopmentMode = true;
        }
        return isDevelopmentMode;
    }

    private boolean checkConfluenceDevLicence() {
        LicenseType type;
        com.atlassian.license.LicenseType licenseType;
        boolean isConfluenceDevLicence = false;
        License confluenceLicense = LicenseManager.getInstance().getLicense("CONF");
        if (confluenceLicense != null && (licenseType = confluenceLicense.getLicenseType()) != null && (LicenseType.DEVELOPER.equals((Object)(type = LicenseType.valueOf((String)licenseType.getNewLicenseTypeName()))) || LicenseType.TESTING.equals((Object)type))) {
            isConfluenceDevLicence = true;
        }
        return isConfluenceDevLicence;
    }

    public Option<PluginLicense> getLicense() {
        Option option = this.licenseManager.getLicense();
        return option;
    }

    public URI getPluginManagementUri() {
        String pluginKey = this.licenseManager.getPluginKey();
        return URI.create(this.applicationProperties.getBaseUrl(UrlMode.AUTO) + "/plugins/servlet/upm?fragment=manage/" + pluginKey).normalize();
    }

    @Override
    public boolean isLicensed() {
        return this.getCachedLicenseStatus().isActive();
    }

    @Override
    public PluginLicenseStatus getPluginLicenseStatus() {
        return new PluginLicenseStatus(this.getCachedLicenseStatus());
    }

    @Override
    public AdhocLicenseManager.LicenseStatus getLicenseStatus() {
        try {
            if (this.getLicense().isDefined()) {
                PluginLicense pluginLicense = (PluginLicense)this.getLicense().get();
                if (pluginLicense.getError().isDefined()) {
                    LicenseError licenseError = (LicenseError)pluginLicense.getError().get();
                    if (licenseError == LicenseError.EXPIRED) {
                        return AdhocLicenseManager.LicenseStatus.EXPIRED;
                    }
                    if (licenseError == LicenseError.VERSION_MISMATCH) {
                        return AdhocLicenseManager.LicenseStatus.MAINTENANCE_EXPIRED;
                    }
                    if (licenseError == LicenseError.USER_MISMATCH) {
                        return AdhocLicenseManager.LicenseStatus.USER_MISMATCH;
                    }
                    return AdhocLicenseManager.LicenseStatus.EXPIRED;
                }
                if (pluginLicense.isEvaluation()) {
                    return AdhocLicenseManager.LicenseStatus.EVALUATION;
                }
                if (pluginLicense.isValid()) {
                    return AdhocLicenseManager.LicenseStatus.LICENSED;
                }
                return AdhocLicenseManager.LicenseStatus.NO_LICENSE;
            }
            return AdhocLicenseManager.LicenseStatus.NO_LICENSE;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return AdhocLicenseManager.LicenseStatus.NOT_AVAILABLE;
        }
    }

    public int getDaysLeft(PluginLicense license) {
        long msLeft = ((DateTime)license.getExpiryDate().get()).getMillis() - this.now().getTime();
        return (int)(msLeft / (long)(this.CACHE_TTL_MS * 24));
    }

    @Override
    public String getCurrentVersion() {
        return this.pluginAccessor.getPlugin(this.licenseManager.getPluginKey()).getPluginInformation().getVersion();
    }

    @Override
    public String getAppKey() {
        return this.licenseManager.getPluginKey();
    }

    @Override
    public int getLicensedUsers() {
        if (this.licenseManager.getLicense().isDefined()) {
            return (Integer)((PluginLicense)this.licenseManager.getLicense().get()).getEdition().get();
        }
        return 0;
    }

    @Override
    public int getLicensedConfluenceUsers() {
        License license = LicenseManager.getInstance().getLicense("CONF");
        return license.getUsers();
    }

    protected void setCACHE_TTL_MS(int CACHE_TTL_MS) {
        this.CACHE_TTL_MS = CACHE_TTL_MS;
    }

    private void checkLicenseStatusCacheExpiry() {
        if (this.cachedLicenseStatus != null && this.cachedLicenseStatus.licenseStatusCacheExpiry.before(this.now())) {
            this.cachedLicenseStatus = null;
        }
    }

    private boolean isAboutToExpire(PluginLicense license) {
        return license != null && ((DateTime)license.getExpiryDate().get()).getMillis() - ABOUT_TO_EXPIRE_OFFSET_MS <= this.now().getTime();
    }

    private AdhocLicenseManager.LicenseStatus getCachedLicenseStatus() {
        this.checkLicenseStatusCacheExpiry();
        if (this.cachedLicenseStatus == null) {
            this.cachedLicenseStatus = new CachedLicenseStatus(this.getLicenseStatus());
        } else if (!this.cachedLicenseStatus.licenseStatus.isActive()) {
            this.cachedLicenseStatus = new CachedLicenseStatus(this.getLicenseStatus(), this.now());
        }
        return this.cachedLicenseStatus.licenseStatus;
    }

    private Date now() {
        return new Date();
    }

    private String makeLicenseStatusMessage(AdhocLicenseManager.LicenseStatus status) {
        try {
            if (status == AdhocLicenseManager.LicenseStatus.LICENSED) {
                return "";
            }
            String upmUrl = this.getPluginManagementUri().toString();
            if (status == AdhocLicenseManager.LicenseStatus.NO_LICENSE || status == AdhocLicenseManager.LicenseStatus.EXPIRED) {
                return this.getText(status.getMessageKey(), upmUrl);
            }
            if (status == AdhocLicenseManager.LicenseStatus.EVALUATION) {
                PluginLicense license;
                if (this.licenseManager.getLicense().isDefined() && this.isAboutToExpire(license = (PluginLicense)this.licenseManager.getLicense().get())) {
                    int days = this.getDaysLeft(license);
                    if (days > 0) {
                        return this.getText("adhoclists.license.abouttoexpire", Integer.toString(days), upmUrl);
                    }
                    return this.getText("adhoclists.license.abouttoexpire.0", upmUrl);
                }
                return "";
            }
            if (status == AdhocLicenseManager.LicenseStatus.MAINTENANCE_EXPIRED) {
                return this.getText(status.getMessageKey(), this.getCurrentVersion(), upmUrl);
            }
            if (status == AdhocLicenseManager.LicenseStatus.USER_MISMATCH) {
                return this.getText(status.getMessageKey(), Integer.toString(this.getLicensedUsers()), Integer.toString(this.getLicensedConfluenceUsers()), upmUrl);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return this.getText(AdhocLicenseManager.LicenseStatus.NOT_AVAILABLE.getMessageKey(), new String[0]);
    }

    private String getText(String key, String ... params) {
        return ConfluenceActionSupport.getTextStatic((String)key, (Object[])params);
    }

    public class PluginLicenseStatus {
        AdhocLicenseManager.LicenseStatus licenseStatus;
        String statusMessageHtml;

        public PluginLicenseStatus(AdhocLicenseManager.LicenseStatus licenseStatus) {
            this.licenseStatus = licenseStatus;
            this.statusMessageHtml = DefaultAdhocLicenseManager.this.makeLicenseStatusMessage(licenseStatus);
        }

        public boolean isLicensed() {
            return this.licenseStatus == AdhocLicenseManager.LicenseStatus.LICENSED;
        }

        public AdhocLicenseManager.LicenseStatus getLicenseStatus() {
            return this.licenseStatus;
        }

        public String getStatusMessageHtml() {
            return this.statusMessageHtml;
        }
    }

    public class CachedLicenseStatus {
        private AdhocLicenseManager.LicenseStatus licenseStatus = null;
        private Date licenseStatusCacheExpiry;

        public CachedLicenseStatus(AdhocLicenseManager.LicenseStatus licenseStatus) {
            this.licenseStatus = licenseStatus;
            this.licenseStatusCacheExpiry = new Date(DefaultAdhocLicenseManager.this.now().getTime() + (long)DefaultAdhocLicenseManager.this.CACHE_TTL_MS);
        }

        public CachedLicenseStatus(AdhocLicenseManager.LicenseStatus licenseStatus, Date licenseStatusCacheExpiry) {
            this.licenseStatus = licenseStatus;
            this.licenseStatusCacheExpiry = licenseStatusCacheExpiry;
        }
    }
}

